/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.android.tools.build.bundletool.model.ConfigurationSizes;
import com.android.tools.build.bundletool.model.SizeConfiguration;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;

public class ConfigurationSizesMerger {
    public static ConfigurationSizes merge(ConfigurationSizes config1, ConfigurationSizes config2) {
        return ConfigurationSizes.create(ConfigurationSizesMerger.mergeSizeConfigurationMap(config1.getMinSizeConfigurationMap(), config2.getMinSizeConfigurationMap()), ConfigurationSizesMerger.mergeSizeConfigurationMap(config1.getMaxSizeConfigurationMap(), config2.getMaxSizeConfigurationMap()));
    }

    private static ImmutableMap<SizeConfiguration, Long> mergeSizeConfigurationMap(ImmutableMap<SizeConfiguration, Long> map1, ImmutableMap<SizeConfiguration, Long> map2) {
        return (ImmutableMap)map1.entrySet().stream().flatMap(entry1 -> map2.entrySet().stream().filter(entry2 -> ConfigurationSizesMerger.areCompatible((SizeConfiguration)entry1.getKey(), (SizeConfiguration)entry2.getKey())).map(entry2 -> ConfigurationSizesMerger.combineEntries(entry1, entry2))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static boolean areCompatible(SizeConfiguration sizeConfig1, SizeConfiguration sizeConfig2) {
        return ConfigurationSizesMerger.areCompatible(sizeConfig1.getAbi(), sizeConfig2.getAbi()) && ConfigurationSizesMerger.areCompatible(sizeConfig1.getLocale(), sizeConfig2.getLocale()) && ConfigurationSizesMerger.areCompatible(sizeConfig1.getScreenDensity(), sizeConfig2.getScreenDensity()) && ConfigurationSizesMerger.areCompatible(sizeConfig1.getSdkVersion(), sizeConfig2.getSdkVersion()) && ConfigurationSizesMerger.areCompatible(sizeConfig1.getTextureCompressionFormat(), sizeConfig2.getTextureCompressionFormat()) && ConfigurationSizesMerger.areCompatible(sizeConfig1.getDeviceGroup(), sizeConfig2.getDeviceGroup()) && ConfigurationSizesMerger.areCompatible(sizeConfig1.getDeviceTier(), sizeConfig2.getDeviceTier()) && ConfigurationSizesMerger.areCompatible(sizeConfig1.getCountrySet(), sizeConfig2.getCountrySet()) && ConfigurationSizesMerger.areCompatible(sizeConfig1.getSdkRuntime(), sizeConfig2.getSdkRuntime());
    }

    private static <T> boolean areCompatible(Optional<T> value1, Optional<T> value2) {
        return value1.equals(value2) || !value1.isPresent() || !value2.isPresent();
    }

    private static Map.Entry<SizeConfiguration, Long> combineEntries(Map.Entry<SizeConfiguration, Long> entry1, Map.Entry<SizeConfiguration, Long> entry2) {
        Preconditions.checkState((boolean)ConfigurationSizesMerger.areCompatible(entry1.getKey(), entry2.getKey()), (Object)"Tried to combine incompatible size configurations.");
        SizeConfiguration.Builder configBuilder = entry1.getKey().toBuilder();
        entry2.getKey().getAbi().ifPresent(configBuilder::setAbi);
        entry2.getKey().getLocale().ifPresent(configBuilder::setLocale);
        entry2.getKey().getScreenDensity().ifPresent(configBuilder::setScreenDensity);
        entry2.getKey().getSdkVersion().ifPresent(configBuilder::setSdkVersion);
        entry2.getKey().getTextureCompressionFormat().ifPresent(configBuilder::setTextureCompressionFormat);
        entry2.getKey().getDeviceGroup().ifPresent(configBuilder::setDeviceGroup);
        entry2.getKey().getDeviceTier().ifPresent(configBuilder::setDeviceTier);
        entry2.getKey().getCountrySet().ifPresent(configBuilder::setCountrySet);
        entry2.getKey().getSdkRuntime().ifPresent(configBuilder::setSdkRuntime);
        return Maps.immutableEntry((Object)configBuilder.build(), (Object)(entry1.getValue() + entry2.getValue()));
    }

    private ConfigurationSizesMerger() {
    }
}

