/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.exceptions;

import com.android.tools.build.bundletool.model.exceptions.BundleToolException;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import javax.annotation.Nullable;

public class UserExceptionBuilder<T extends BundleToolException> {
    private final ExceptionCreator<T> creator;
    @Nullable
    private Throwable cause;
    @Nullable
    private String userMessage;

    UserExceptionBuilder(ExceptionCreator<T> creator) {
        this.creator = creator;
    }

    public UserExceptionBuilder<T> withUserMessage(String userMessage) {
        this.userMessage = userMessage;
        return this;
    }

    @FormatMethod
    public UserExceptionBuilder<T> withUserMessage(@FormatString String message2, Object ... args) {
        this.userMessage = String.format((String)Preconditions.checkNotNull((Object)message2), args);
        return this;
    }

    public UserExceptionBuilder<T> withCause(Throwable cause) {
        this.cause = cause;
        return this;
    }

    @CheckReturnValue
    public T build() {
        String effectiveUserMessage = Strings.nullToEmpty((String)this.userMessage);
        String effectiveInternalMessage = this.userMessage == null ? (this.cause == null ? "" : this.cause.toString()) : this.userMessage;
        return this.creator.create(effectiveUserMessage, effectiveInternalMessage, this.cause);
    }

    @FunctionalInterface
    static interface ExceptionCreator<T extends BundleToolException> {
        public T create(String var1, String var2, Throwable var3);
    }
}

