/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.tools.build.bundletool.commands.BuildApksModule;
import com.android.tools.build.bundletool.io.ApkSerializerHelper;
import com.android.tools.build.bundletool.io.ApkSerializerModule;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.ApksigSigningConfiguration;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.SignerConfig;
import com.android.tools.build.bundletool.model.SigningConfigurationProvider;
import com.android.tools.build.bundletool.model.SourceStamp;
import com.android.tools.build.bundletool.model.WearApkLocator;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CheckReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import shadow.bundletool.com.android.apksig.ApkSigner;
import shadow.bundletool.com.android.apksig.apk.ApkFormatException;

class ApkSigner {
    private static final String SIGNER_CONFIG_NAME = "BNDLTOOL";
    private final Optional<SigningConfigurationProvider> signingConfigProvider;
    private final Optional<SourceStamp> sourceStampSigningConfig;
    private final TempDirectory tempDirectory;
    private final int nativeLibrariesAlignment;

    @Inject
    ApkSigner(@BuildApksModule.ApkSigningConfigProvider Optional<SigningConfigurationProvider> signingConfigProvider, Optional<SourceStamp> sourceStampSigningConfig, TempDirectory tempDirectory, @ApkSerializerModule.NativeLibrariesAlignmentInBytes int nativeLibrariesAlignment) {
        this.signingConfigProvider = signingConfigProvider;
        this.sourceStampSigningConfig = sourceStampSigningConfig;
        this.tempDirectory = tempDirectory;
        this.nativeLibrariesAlignment = nativeLibrariesAlignment;
    }

    public Optional<Commands.SigningDescription> signApk(Path apkPath, ModuleSplit split) {
        if (!this.signingConfigProvider.isPresent()) {
            return Optional.empty();
        }
        ApksigSigningConfiguration signingConfig = this.signingConfigProvider.get().getSigningConfiguration(SigningConfigurationProvider.ApkDescription.fromModuleSplit(split));
        TempDirectory tempDirectory = new TempDirectory(this.getClass().getSimpleName());
        try {
            Path signedApkPath = tempDirectory.getPath().resolve("signed.apk");
            ApkSigner.Builder apkSigner = new ApkSigner.Builder((List)signingConfig.getSignerConfigs().stream().map(ApkSigner::convertToApksigSignerConfig).collect(ImmutableList.toImmutableList())).setInputApk(apkPath.toFile()).setOutputApk(signedApkPath.toFile()).setV1SigningEnabled(signingConfig.getV1SigningEnabled()).setV2SigningEnabled(signingConfig.getV2SigningEnabled()).setV3SigningEnabled(signingConfig.getV3SigningEnabled()).setOtherSignersSignaturesPreserved(false).setMinSdkVersion(split.getAndroidManifest().getEffectiveMinSdkVersion());
            signingConfig.getSigningCertificateLineage().ifPresent(apkSigner::setSigningCertificateLineage);
            this.sourceStampSigningConfig.ifPresent(stampConfig -> apkSigner.setSourceStampSignerConfig(ApkSigner.convertToApksigSignerConfig(stampConfig.getSigningConfiguration().getSignerConfig())));
            apkSigner.build().sign();
            Files.move(signedApkPath, apkPath, StandardCopyOption.REPLACE_EXISTING);
            Optional<Commands.SigningDescription> optional = Optional.of(this.signingDescription(signingConfig));
            tempDirectory.close();
            return optional;
        }
        catch (Throwable throwable) {
            try {
                try {
                    tempDirectory.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | ApkFormatException e11) {
                throw CommandExecutionException.builder().withCause(e11).withInternalMessage("Unable to sign APK.").build();
            }
        }
    }

    private Commands.SigningDescription signingDescription(ApksigSigningConfiguration signingConfig) {
        boolean usesKeyRotation = signingConfig.getSigningCertificateLineage().map(lineage -> lineage.size() > 1).orElse(false);
        return Commands.SigningDescription.newBuilder().setSignedWithRotatedKey(usesKeyRotation).build();
    }

    @CheckReturnValue
    public ModuleSplit signEmbeddedApks(ModuleSplit split) {
        ImmutableSet wear1ApkPaths = ImmutableSet.copyOf(WearApkLocator.findEmbeddedWearApkPaths(split));
        ImmutableList.Builder newEntries = ImmutableList.builder();
        for (ModuleEntry entry : split.getEntries()) {
            ZipPath pathInApk = ApkSerializerHelper.toApkEntryPath(entry.getPath());
            if (entry.getShouldSign() || wear1ApkPaths.contains((Object)pathInApk)) {
                newEntries.add((Object)this.signModuleEntry(split, entry));
                continue;
            }
            newEntries.add((Object)entry);
        }
        return split.toBuilder().setEntries((List<ModuleEntry>)newEntries.build()).build();
    }

    private ModuleEntry signModuleEntry(ModuleSplit split, ModuleEntry entry) {
        try {
            Path tempDir = Files.createTempDirectory(this.tempDirectory.getPath(), this.getClass().getSimpleName(), new FileAttribute[0]);
            Path embeddedApk = tempDir.resolve("embedded.apk");
            try (InputStream entryContent = entry.getContent().openStream();){
                Files.copy(entryContent, embeddedApk, new CopyOption[0]);
            }
            this.signApk(embeddedApk, split);
            return entry.toBuilder().setContent(embeddedApk).setShouldSign(false).build();
        }
        catch (IOException e11) {
            throw new UncheckedIOException(e11);
        }
    }

    private static ApkSigner.SignerConfig convertToApksigSignerConfig(SignerConfig signerConfig) {
        return new ApkSigner.SignerConfig.Builder(SIGNER_CONFIG_NAME, signerConfig.getPrivateKey(), (List<X509Certificate>)signerConfig.getCertificates()).build();
    }
}

