/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\u0016\u001a\u00020\u0014J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0003J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0000J\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\t\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/android/aaptcompiler/buffer/BigBuffer;", "", "blockSize", "", "<init>", "(I)V", "getBlockSize", "()I", "value", "size", "getSize", "blocks", "", "Lcom/android/aaptcompiler/buffer/BigBuffer$Block;", "getBlocks$aaptcompiler", "()Ljava/util/List;", "nextBlock", "Lcom/android/aaptcompiler/buffer/BigBuffer$BlockRef;", "elementSize", "pad", "", "bytes", "align4", "block", "index", "append", "other", "toBytes", "", "Block", "BlockRef", "aaptcompiler"})
public final class BigBuffer {
    private final int blockSize;
    private int size;
    @NotNull
    private final List<Block> blocks;

    public BigBuffer(int blockSize) {
        this.blockSize = blockSize;
        this.blocks = new ArrayList();
    }

    public /* synthetic */ BigBuffer(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1024;
        }
        this(n);
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final List<Block> getBlocks$aaptcompiler() {
        return this.blocks;
    }

    @NotNull
    public final BlockRef nextBlock(int elementSize) {
        Block back;
        if (!((Collection)this.blocks).isEmpty() && (back = (Block)CollectionsKt.last(this.blocks)).getBlockSize$aaptcompiler() - back.getSize$aaptcompiler() >= elementSize) {
            int start = back.getSize$aaptcompiler();
            back.setSize$aaptcompiler(back.getSize$aaptcompiler() + elementSize);
            this.size += elementSize;
            return new BlockRef(start, elementSize, back);
        }
        int actualSize = Math.max(this.blockSize, elementSize);
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[actualSize]).order(ByteOrder.nativeOrder());
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"order(...)");
        Block block = new Block(elementSize, actualSize, byteBuffer);
        this.blocks.add(block);
        this.size += elementSize;
        return new BlockRef(0, elementSize, block);
    }

    public final void pad(int bytes) {
        this.nextBlock(bytes);
    }

    public final void align4() {
        int unaligned = this.size % 4;
        if (unaligned != 0) {
            this.pad(4 - unaligned);
        }
    }

    @NotNull
    public final BlockRef block(int index) {
        return new BlockRef(0, this.blocks.get(index).getSize$aaptcompiler(), this.blocks.get(index));
    }

    public final void append(@NotNull BigBuffer other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.blocks.addAll((Collection<Block>)other.blocks);
        this.size += other.size;
        other.blocks.clear();
        other.size = 0;
    }

    @NotNull
    public final byte[] toBytes() {
        byte[] array = new byte[this.size];
        int currentLocation = 0;
        for (Block block : this.blocks) {
            ByteBuffer data;
            Intrinsics.checkNotNull((Object)block.getData$aaptcompiler().position(0), (String)"null cannot be cast to non-null type java.nio.ByteBuffer");
            data.get(array, currentLocation, block.getSize$aaptcompiler());
            currentLocation += block.getSize$aaptcompiler();
        }
        return array;
    }

    public BigBuffer() {
        this(0, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/android/aaptcompiler/buffer/BigBuffer$Block;", "", "size", "", "blockSize", "data", "Ljava/nio/ByteBuffer;", "<init>", "(IILjava/nio/ByteBuffer;)V", "getSize$aaptcompiler", "()I", "setSize$aaptcompiler", "(I)V", "getBlockSize$aaptcompiler", "getData$aaptcompiler", "()Ljava/nio/ByteBuffer;", "aaptcompiler"})
    public static final class Block {
        private int size;
        private final int blockSize;
        @NotNull
        private final ByteBuffer data;

        public Block(int size, int blockSize, @NotNull ByteBuffer data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.size = size;
            this.blockSize = blockSize;
            this.data = data;
        }

        public final int getSize$aaptcompiler() {
            return this.size;
        }

        public final void setSize$aaptcompiler(int n) {
            this.size = n;
        }

        public final int getBlockSize$aaptcompiler() {
            return this.blockSize;
        }

        @NotNull
        public final ByteBuffer getData$aaptcompiler() {
            return this.data;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003J\u0016\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0003J\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0003J\u000e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003J\u000e\u0010\u0019\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u001aJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u001c\u001a\u00020\u0006H\u00c0\u0003\u00a2\u0006\u0002\b\u001dJ'\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006%"}, d2={"Lcom/android/aaptcompiler/buffer/BigBuffer$BlockRef;", "", "start", "", "size", "block", "Lcom/android/aaptcompiler/buffer/BigBuffer$Block;", "<init>", "(IILcom/android/aaptcompiler/buffer/BigBuffer$Block;)V", "getStart$aaptcompiler", "()I", "getSize", "getBlock$aaptcompiler", "()Lcom/android/aaptcompiler/buffer/BigBuffer$Block;", "writeByte", "", "value", "", "location", "writeShort", "", "writeInt", "readByte", "readShort", "readInt", "component1", "component1$aaptcompiler", "component2", "component3", "component3$aaptcompiler", "copy", "equals", "", "other", "hashCode", "toString", "", "aaptcompiler"})
    public static final class BlockRef {
        private final int start;
        private final int size;
        @NotNull
        private final Block block;

        public BlockRef(int start, int size, @NotNull Block block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            this.start = start;
            this.size = size;
            this.block = block;
        }

        public final int getStart$aaptcompiler() {
            return this.start;
        }

        public final int getSize() {
            return this.size;
        }

        @NotNull
        public final Block getBlock$aaptcompiler() {
            return this.block;
        }

        public final void writeByte(byte value, int location) {
            if (location + 1 > this.size) {
                throw new IndexOutOfBoundsException();
            }
            int actualLocation = this.start + location;
            this.block.getData$aaptcompiler().put(actualLocation, value);
        }

        public final void writeShort(short value, int location) {
            if (location + 2 > this.size) {
                throw new IndexOutOfBoundsException();
            }
            int actualLocation = this.start + location;
            this.block.getData$aaptcompiler().putShort(actualLocation, value);
        }

        public final void writeInt(int value, int location) {
            if (location + 4 > this.size) {
                throw new IndexOutOfBoundsException();
            }
            int actualLocation = this.start + location;
            this.block.getData$aaptcompiler().putInt(actualLocation, value);
        }

        public final byte readByte(int location) {
            if (location + 1 > this.size) {
                throw new IndexOutOfBoundsException();
            }
            int actualLocation = this.start + location;
            return this.block.getData$aaptcompiler().get(actualLocation);
        }

        public final short readShort(int location) {
            if (location + 2 > this.size) {
                throw new IndexOutOfBoundsException();
            }
            int actualLocation = this.start + location;
            return this.block.getData$aaptcompiler().getShort(actualLocation);
        }

        public final int readInt(int location) {
            if (location + 4 > this.size) {
                throw new IndexOutOfBoundsException();
            }
            int actualLocation = this.start + location;
            return this.block.getData$aaptcompiler().getInt(actualLocation);
        }

        public final int component1$aaptcompiler() {
            return this.start;
        }

        public final int component2() {
            return this.size;
        }

        @NotNull
        public final Block component3$aaptcompiler() {
            return this.block;
        }

        @NotNull
        public final BlockRef copy(int start, int size, @NotNull Block block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            return new BlockRef(start, size, block);
        }

        public static /* synthetic */ BlockRef copy$default(BlockRef blockRef, int n, int n2, Block block, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = blockRef.start;
            }
            if ((n3 & 2) != 0) {
                n2 = blockRef.size;
            }
            if ((n3 & 4) != 0) {
                block = blockRef.block;
            }
            return blockRef.copy(n, n2, block);
        }

        @NotNull
        public String toString() {
            return "BlockRef(start=" + this.start + ", size=" + this.size + ", block=" + this.block + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.start);
            result = result * 31 + Integer.hashCode(this.size);
            result = result * 31 + this.block.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BlockRef)) {
                return false;
            }
            BlockRef blockRef = (BlockRef)other;
            if (this.start != blockRef.start) {
                return false;
            }
            if (this.size != blockRef.size) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.block, (Object)blockRef.block);
        }
    }
}

