/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import com.android.aaptcompiler.PseudoMethodImpl;
import com.android.aaptcompiler.PseudolocalizerKt;
import com.android.aaptcompiler.android.UtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0005H\u0002J$\u0010\u0017\u001a\u00020\u00052\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J$\u0010\u001d\u001a\u00020\u00052\n\u0010\u001e\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0005H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u000e\u0010\u001f\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/aaptcompiler/PseudoMethodAccent;", "Lcom/android/aaptcompiler/PseudoMethodImpl;", "<init>", "()V", "depth", "", "getDepth", "()I", "setDepth", "(I)V", "wordCount", "getWordCount", "setWordCount", "length", "getLength", "setLength", "start", "", "end", "text", "originalText", "placeholder", "pseudoGenerateExpansion", "processMaybePlaceholder", "partial", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "source", "startIndex", "processHtml", "sourcePartial", "EXPANSION_STRING", "aaptcompiler"})
public final class PseudoMethodAccent
extends PseudoMethodImpl {
    private int depth;
    private int wordCount;
    private int length;
    @NotNull
    private final String EXPANSION_STRING;

    public PseudoMethodAccent() {
        this.EXPANSION_STRING = "one two three four five six seven eight nine ten eleven twelve thirteen fourteen fiveteen sixteen seventeen nineteen twenty";
    }

    public final int getDepth() {
        return this.depth;
    }

    public final void setDepth(int n) {
        this.depth = n;
    }

    public final int getWordCount() {
        return this.wordCount;
    }

    public final void setWordCount(int n) {
        this.wordCount = n;
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int n) {
        this.length = n;
    }

    @Override
    @NotNull
    public String start() {
        String result = "";
        if (this.depth == 0) {
            result = "[";
        }
        this.wordCount = 0;
        this.length = 0;
        ++this.depth;
        return result;
    }

    @Override
    @NotNull
    public String end() {
        StringBuilder result = new StringBuilder();
        if (UtilKt.isTruthy(this.length)) {
            result.append(' ');
            result.append(this.pseudoGenerateExpansion(this.wordCount > 3 ? this.length : this.length / 2));
        }
        this.wordCount = 0;
        this.length = 0;
        this.depth += -1;
        if (this.depth == 0) {
            result.append("]");
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public String text(@NotNull String originalText) {
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        StringBuilder result = new StringBuilder();
        int size = originalText.length();
        boolean lastSpace = true;
        block4: for (int currentIndex = 0; currentIndex < size; ++currentIndex) {
            char currentChar = originalText.charAt(currentIndex);
            switch (currentChar) {
                case '%': {
                    currentIndex = this.processMaybePlaceholder(result, originalText, currentIndex);
                    continue block4;
                }
                case '&': 
                case '<': {
                    currentIndex = this.processHtml(result, originalText, currentIndex);
                    continue block4;
                }
                default: {
                    StringBuilder stringBuilder;
                    String localized = PseudolocalizerKt.access$pseudoLocalize(currentChar);
                    if (localized != null) {
                        stringBuilder = result.append(localized);
                    } else {
                        boolean space = CharsKt.isWhitespace((char)currentChar);
                        if (lastSpace && !space) {
                            ++this.wordCount;
                        }
                        lastSpace = space;
                        stringBuilder = result.append(currentChar);
                    }
                    ++this.length;
                }
            }
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public String placeholder(@NotNull String originalText) {
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        return "\u00bb" + originalText + "\u00ab";
    }

    private final String pseudoGenerateExpansion(int length) {
        StringBuilder result = new StringBuilder(this.EXPANSION_STRING);
        while (result.length() < length) {
            result.append(" ");
            result.append(this.EXPANSION_STRING);
        }
        int lastSpace = StringsKt.indexOf$default((CharSequence)result, (char)' ', (int)(length + 1), (boolean)false, (int)4, null);
        String string = result.substring(0, lastSpace == -1 ? result.length() : lastSpace);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private final int processMaybePlaceholder(StringBuilder partial, String source, int startIndex) {
        CharSequence charSequence;
        int size = source.length();
        int currentIndex = startIndex;
        char currentChar = source.charAt(currentIndex);
        StringBuilder chunk = new StringBuilder().append(currentChar);
        while (currentIndex + 1 < size) {
            currentChar = source.charAt(++currentIndex);
            chunk.append(currentChar);
            if (PseudolocalizerKt.access$isPossiblePlaceHolderEnd(currentChar)) break;
            if (currentIndex + 1 >= size || currentChar != 't') continue;
            currentChar = source.charAt(++currentIndex);
            chunk.append(currentChar);
            break;
        }
        if (currentChar == '%') {
            charSequence = chunk;
        } else {
            String string = chunk.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            charSequence = this.placeholder(string);
        }
        partial.append(charSequence);
        return currentIndex;
    }

    private final int processHtml(StringBuilder sourcePartial, String source, int startIndex) {
        int size = source.length();
        int currentIndex = startIndex;
        char currentChar = source.charAt(currentIndex);
        StringBuilder htmlPartial = new StringBuilder();
        while (currentIndex < size) {
            if (currentChar == '&') {
                StringBuilder escapeText = new StringBuilder().append(currentChar);
                int htmlCodePosition = currentIndex;
                while (htmlCodePosition + 1 < size) {
                    currentChar = source.charAt(++htmlCodePosition);
                    escapeText.append(currentChar);
                    char c = currentChar;
                    if (c == ';') {
                        currentIndex = htmlCodePosition;
                        break;
                    }
                    if (c == '#') continue;
                    if ('a' <= c ? c < '{' : false) continue;
                    if ('A' <= c ? c < '[' : false) continue;
                    if ('0' <= c ? c < ':' : false) continue;
                }
                htmlPartial.append((CharSequence)escapeText);
                if (Intrinsics.areEqual((Object)escapeText.toString(), (Object)"&lt;")) continue;
                break;
            }
            if (currentChar == '>') {
                htmlPartial.append('>');
                break;
            }
            htmlPartial.append(currentChar);
            if (++currentIndex >= size) {
                sourcePartial.append(source.charAt(startIndex));
                return startIndex;
            }
            currentChar = source.charAt(currentIndex);
        }
        sourcePartial.append(htmlPartial.toString());
        return currentIndex;
    }
}

