/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tea.interceptor;

import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.TeaResponse;
import com.aliyun.tea.interceptor.InterceptorContext;
import com.aliyun.tea.interceptor.RequestInterceptor;
import com.aliyun.tea.interceptor.ResponseInterceptor;
import com.aliyun.tea.interceptor.RuntimeOptionsInterceptor;
import com.aliyun.tea.utils.AttributeMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InterceptorChain
implements AutoCloseable {
    private List<RuntimeOptionsInterceptor> runtimeOptionsInterceptors = new ArrayList<RuntimeOptionsInterceptor>();
    private List<RequestInterceptor> requestInterceptors = new ArrayList<RequestInterceptor>();
    private List<ResponseInterceptor> responseInterceptors = new ArrayList<ResponseInterceptor>();

    private InterceptorChain() {
    }

    public static InterceptorChain create() {
        return new InterceptorChain();
    }

    public void addRuntimeOptionsInterceptor(RuntimeOptionsInterceptor interceptor) {
        this.runtimeOptionsInterceptors.add(interceptor);
    }

    public void addRequestInterceptor(RequestInterceptor interceptor) {
        this.requestInterceptors.add(interceptor);
    }

    public void addResponseInterceptor(ResponseInterceptor interceptor) {
        this.responseInterceptors.add(interceptor);
    }

    @Override
    public void close() {
        this.runtimeOptionsInterceptors.clear();
        this.requestInterceptors.clear();
        this.responseInterceptors.clear();
    }

    public InterceptorContext modifyRuntimeOptions(InterceptorContext context, AttributeMap attributes) {
        InterceptorContext result = context;
        for (RuntimeOptionsInterceptor interceptor : this.runtimeOptionsInterceptors) {
            Map<String, Object> interceptorResult = interceptor.modifyRuntimeOptions(result, attributes);
            result.setRuntimeOptions(interceptorResult);
        }
        return result;
    }

    public InterceptorContext modifyRequest(InterceptorContext context, AttributeMap attributes) {
        InterceptorContext result = context;
        for (RequestInterceptor interceptor : this.requestInterceptors) {
            TeaRequest interceptorResult = interceptor.modifyRequest(result, attributes);
            result.setTeaRequest(interceptorResult);
        }
        return result;
    }

    public InterceptorContext modifyResponse(InterceptorContext context, AttributeMap attributes) {
        InterceptorContext result = context;
        for (ResponseInterceptor interceptor : this.responseInterceptors) {
            TeaResponse interceptorResult = interceptor.modifyResponse(result, attributes);
            result.setTeaResponse(interceptorResult);
        }
        return result;
    }
}

