/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.writer.dispatch;

import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.writer.dispatch.BaseDispatcher;

public class HashPartitionKeyDispatcher
extends BaseDispatcher {
    private int bucketCount;

    public HashPartitionKeyDispatcher(int bucketCount) {
        super(bucketCount);
        this.bucketCount = bucketCount;
    }

    @Override
    public int getDispatchIndex(RowChange rowChange) {
        int bucketIndex = rowChange.getPrimaryKey().getPrimaryKeyColumn(0).hashCode() % this.bucketCount;
        bucketIndex = (bucketIndex + this.bucketCount) % this.bucketCount;
        this.addBucketCount(bucketIndex);
        return bucketIndex;
    }
}

