/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.sql;

import com.alicloud.openservices.tablestore.model.sql.SQLFactory;
import com.alicloud.openservices.tablestore.model.sql.SQLPayloadVersion;
import com.alicloud.openservices.tablestore.model.sql.SQLResultSet;
import com.alicloud.openservices.tablestore.model.sql.SQLRow;
import com.alicloud.openservices.tablestore.model.sql.SQLRows;
import com.alicloud.openservices.tablestore.model.sql.SQLTableMeta;
import com.google.protobuf.ByteString;

public class SQLResultSetImpl
implements SQLResultSet {
    private SQLRows sqlRows;
    private int current = 0;

    public SQLResultSetImpl(SQLPayloadVersion version, ByteString rows) {
        this.sqlRows = SQLFactory.getSQLRows(version, rows);
    }

    @Override
    public SQLTableMeta getSQLTableMeta() {
        return this.sqlRows.getSQLTableMeta();
    }

    @Override
    public boolean hasNext() {
        return (long)this.current < this.sqlRows.rowCount();
    }

    @Override
    public SQLRow next() {
        if (this.hasNext()) {
            SQLRow sqlRow = SQLFactory.getSQLRow(this.sqlRows, this.current);
            ++this.current;
            return sqlRow;
        }
        throw new IllegalStateException("SQLRow doesn't have next row");
    }

    @Override
    public long rowCount() {
        return this.sqlRows.rowCount();
    }

    @Override
    public boolean absolute(int rowIndex) {
        if ((long)rowIndex >= this.sqlRows.rowCount() || rowIndex < 0) {
            return false;
        }
        this.current = rowIndex;
        return true;
    }
}

