/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.query;

import com.alicloud.openservices.tablestore.core.protocol.SearchQueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.Query;
import com.alicloud.openservices.tablestore.model.search.query.QueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.QueryType;
import com.google.protobuf.ByteString;

public class GeoBoundingBoxQuery
implements Query {
    private QueryType queryType = QueryType.QueryType_GeoBoundingBoxQuery;
    private String fieldName;
    private String topLeft;
    private String bottomRight;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getTopLeft() {
        return this.topLeft;
    }

    public void setTopLeft(String topLeft) {
        this.topLeft = topLeft;
    }

    public String getBottomRight() {
        return this.bottomRight;
    }

    public void setBottomRight(String bottomRight) {
        this.bottomRight = bottomRight;
    }

    @Override
    public QueryType getQueryType() {
        return this.queryType;
    }

    @Override
    public ByteString serialize() {
        return SearchQueryBuilder.buildGeoBoundingBoxQuery(this).toByteString();
    }

    protected static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    implements QueryBuilder {
        private String fieldName;
        private String topLeft;
        private String bottomRight;

        private Builder() {
        }

        public Builder field(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder topLeft(String topLeft) {
            this.topLeft = topLeft;
            return this;
        }

        public Builder bottomRight(String bottomRight) {
            this.bottomRight = bottomRight;
            return this;
        }

        @Override
        public GeoBoundingBoxQuery build() {
            GeoBoundingBoxQuery boundingBoxQuery = new GeoBoundingBoxQuery();
            boundingBoxQuery.setBottomRight(this.bottomRight);
            boundingBoxQuery.setTopLeft(this.topLeft);
            boundingBoxQuery.setFieldName(this.fieldName);
            return boundingBoxQuery;
        }
    }
}

