/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.PartialResultFailedException;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class DefaultRetryStrategy
implements RetryStrategy {
    private final int MAX_BASE = 320;
    private Random rnd = new Random();
    private int retries = 0;
    private long timeout = 0L;
    private int base = 10;
    private long deadline = 0L;

    public DefaultRetryStrategy() {
        this(10L, TimeUnit.SECONDS);
    }

    public DefaultRetryStrategy(long timeout, TimeUnit unit) {
        this.timeout = unit.toMillis(timeout);
        this.deadline = System.currentTimeMillis() + this.timeout;
    }

    @Override
    public RetryStrategy clone() {
        return new DefaultRetryStrategy(this.timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    protected boolean isIdempotent(String action) {
        return action.equals("BatchGetRow") || action.equals("DescribeTable") || action.equals("GetRange") || action.equals("GetRow") || action.equals("ListTable") || action.equals("tunnel/list") || action.equals("tunnel/describe") || action.equals("tunnel/readrecords");
    }

    protected boolean retryNotMatterActions(String errorCode, String errorMessage) {
        return errorCode.equals("OTSRowOperationConflict") || errorCode.equals("OTSNotEnoughCapacityUnit") || errorCode.equals("OTSTableNotReady") || errorCode.equals("OTSPartitionUnavailable") || errorCode.equals("OTSServerBusy") || errorCode.equals("OTSQuotaExhausted") && errorMessage.equals("Too frequent table operations.");
    }

    protected boolean shouldRetryWithOTSException(String action, boolean isIdempotent, String errorCode, String errorMessage, int httpStatus) {
        boolean serverError;
        if (this.retryNotMatterActions(errorCode, errorMessage)) {
            return true;
        }
        boolean bl = serverError = httpStatus >= 500 && httpStatus <= 599;
        return isIdempotent && (errorCode.equals("OTSTimeout") || errorCode.equals("OTSInternalServerError") || errorCode.equals("OTSServerUnavailable") || errorCode.equals("OTSTunnelServerUnavailable") || serverError);
    }

    public boolean shouldRetry(String action, Exception ex) {
        boolean isIdempotent = this.isIdempotent(action);
        if (ex instanceof TableStoreException) {
            if (ex instanceof PartialResultFailedException) {
                PartialResultFailedException prfe = (PartialResultFailedException)ex;
                for (TableStoreException otsException : prfe.getErrors()) {
                    if (this.shouldRetryWithOTSException(action, isIdempotent, otsException.getErrorCode(), otsException.getMessage(), prfe.getHttpStatus())) continue;
                    return false;
                }
                return true;
            }
            TableStoreException otsException = (TableStoreException)ex;
            return this.shouldRetryWithOTSException(action, isIdempotent, otsException.getErrorCode(), otsException.getMessage(), otsException.getHttpStatus());
        }
        if (ex instanceof ClientException) {
            return isIdempotent;
        }
        return false;
    }

    @Override
    public long nextPause(String action, Exception ex) {
        if (!this.shouldRetry(action, ex)) {
            return 0L;
        }
        if (this.base <= 0) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        int expire = (int)(this.deadline - now);
        if (expire <= 0) {
            return 0L;
        }
        long delay = 1 + this.rnd.nextInt(this.base < expire ? this.base : expire);
        ++this.retries;
        this.base *= 2;
        if (this.base > 320) {
            this.base = 320;
        }
        return delay;
    }
}

