/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.model.ConsumedCapacity;
import com.alicloud.openservices.tablestore.model.Error;
import com.alicloud.openservices.tablestore.model.Response;
import java.util.ArrayList;
import java.util.List;

public class BulkImportResponse
extends Response {
    private String tableName;
    private List<RowResult> rowResults = new ArrayList<RowResult>();

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public BulkImportResponse(Response meta) {
        super(meta);
    }

    public void addRowResult(RowResult rowResults) {
        this.rowResults.add(rowResults);
    }

    public List<RowResult> getRowResults() {
        return this.rowResults;
    }

    public List<RowResult> getFailedRows() {
        ArrayList<RowResult> result = new ArrayList<RowResult>();
        this.getResult(null, result);
        return result;
    }

    public List<RowResult> getSucceedRows() {
        ArrayList<RowResult> result = new ArrayList<RowResult>();
        this.getResult(result, null);
        return result;
    }

    public void getResult(List<RowResult> succeedRows, List<RowResult> failedRows) {
        for (RowResult rs : this.rowResults) {
            if (rs.isSucceed) {
                if (succeedRows == null) continue;
                succeedRows.add(rs);
                continue;
            }
            if (failedRows == null) continue;
            failedRows.add(rs);
        }
    }

    public boolean isAllSucceed() {
        return this.getFailedRows().isEmpty();
    }

    public static class RowResult {
        private boolean isSucceed = false;
        private Error error;
        private ConsumedCapacity consumedCapacity;
        private int index;

        public RowResult(Error error, int index) {
            this.isSucceed = false;
            this.error = error;
            this.index = index;
        }

        public RowResult(ConsumedCapacity consumedCapacity, int index) {
            this.isSucceed = true;
            this.consumedCapacity = consumedCapacity;
            this.index = index;
        }

        public boolean isSucceed() {
            return this.isSucceed;
        }

        public Error getError() {
            return this.error;
        }

        public ConsumedCapacity getConsumedCapacity() {
            return this.consumedCapacity;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

