/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.core.ClientResources;
import java.util.concurrent.ExecutorService;

public class ResourceManager {
    private final ClientResources resources;
    private final boolean owned;
    private final ResourceManager sharedInstance;

    public ResourceManager(ClientConfiguration configuration) {
        this(configuration, null);
    }

    public ResourceManager(ClientConfiguration configuration, ExecutorService callbackExecutor) {
        if (configuration == null) {
            configuration = new ClientConfiguration();
        }
        this.resources = new ClientResources(configuration, callbackExecutor);
        this.owned = true;
        this.sharedInstance = new ResourceManager(this.resources);
    }

    public ResourceManager(ClientResources resources) {
        this.resources = resources;
        this.owned = false;
        this.sharedInstance = null;
    }

    public ResourceManager sharedResourceManager() {
        if (!this.owned) {
            return this;
        }
        return this.sharedInstance;
    }

    public ClientResources getResources() {
        return this.resources;
    }

    public void shutdown() {
        if (this.owned) {
            this.resources.shutdown();
        }
    }
}

