/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeline.model;

import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.timeline.TimelineException;
import com.alicloud.openservices.tablestore.timeline.model.TimelineMessage;
import com.alicloud.openservices.tablestore.timeline.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.CRC32;

public class TimelineMessageForV1 {
    private String stringMessage = null;
    private TimelineMessage message = new TimelineMessage();
    public static final int CONTENT_COLUMN_START_ID = 10000;
    public static final String SYSTEM_COLUMN_NAME_PREFIX = "__";
    private static AtomicInteger baseID = new AtomicInteger(0);
    private static String machineID = Utils.getProcessID() + "@" + Utils.getLocalIP() + ":";
    private String messageIDColumnNameSuffix = "message_id";
    private String messageContentSuffix = "content";
    private String messageContentCountSuffix = "column_count";
    private String columnNameOfMessageCrc32Suffix = "crc32";
    private int columnMaxLength = 0x100000;

    public TimelineMessageForV1(String content) {
        baseID.compareAndSet(Integer.MAX_VALUE, 0);
        String messageID = machineID + String.valueOf(baseID.addAndGet(1));
        this.message.setField(SYSTEM_COLUMN_NAME_PREFIX + this.messageIDColumnNameSuffix, messageID);
        this.setContent(content);
    }

    public TimelineMessageForV1(TimelineMessage message) {
        this.message = message;
    }

    public TimelineMessage getTimelineMessage() {
        return this.message;
    }

    public TimelineMessageForV1 setMessageId(String messageID) {
        this.message.setField(SYSTEM_COLUMN_NAME_PREFIX + this.messageIDColumnNameSuffix, messageID);
        return this;
    }

    public String getMessageID() {
        return this.message.getString(SYSTEM_COLUMN_NAME_PREFIX + this.messageIDColumnNameSuffix);
    }

    public TimelineMessageForV1 setContent(String stringMessage) {
        byte[] columnValue;
        byte[] content = stringMessage.getBytes();
        if (content.length > 0x200000) {
            throw new TimelineException(String.format("Message Content must less than 2MB, current:%s", String.valueOf(content.length)));
        }
        int index = 10000;
        for (int pos = 0; pos < content.length; pos += columnValue.length) {
            columnValue = pos + this.columnMaxLength < content.length ? Arrays.copyOfRange(content, pos, pos + this.columnMaxLength) : Arrays.copyOfRange(content, pos, content.length);
            String columnName = SYSTEM_COLUMN_NAME_PREFIX + this.messageContentSuffix + String.valueOf(index++);
            this.message.setField(new Column(columnName, ColumnValue.fromBinary(columnValue)));
        }
        String columnName = SYSTEM_COLUMN_NAME_PREFIX + this.messageContentCountSuffix;
        this.message.setField(columnName, index - 10000);
        if (this.columnNameOfMessageCrc32Suffix != null && !this.columnNameOfMessageCrc32Suffix.isEmpty()) {
            long crc32 = TimelineMessageForV1.crc32(content);
            String columnName2 = SYSTEM_COLUMN_NAME_PREFIX + this.columnNameOfMessageCrc32Suffix;
            this.message.setField(columnName2, crc32);
        }
        return this;
    }

    public String getContent() {
        long l;
        if (this.stringMessage != null) {
            return this.stringMessage;
        }
        String contentCountName = SYSTEM_COLUMN_NAME_PREFIX + this.messageContentCountSuffix;
        long currentCount = 0L;
        long columnCount = this.message.getLong(contentCountName);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int index = 10000;
        long crc32 = 0L;
        Map<String, Column> columns = this.message.getFields();
        ArrayList<Map.Entry<String, Column>> list = new ArrayList<Map.Entry<String, Column>>(columns.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Column>>(){

            @Override
            public int compare(Map.Entry<String, Column> o1, Map.Entry<String, Column> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        for (Map.Entry entry : list) {
            String key = (String)entry.getKey();
            Column column = columns.get(key);
            String name = column.getName();
            if (name.startsWith(SYSTEM_COLUMN_NAME_PREFIX + this.messageContentSuffix)) {
                if (currentCount == columnCount) continue;
                int columnSeqID = Integer.parseInt(name.substring(SYSTEM_COLUMN_NAME_PREFIX.length() + this.messageContentSuffix.length()));
                if (columnSeqID != index) {
                    throw new TimelineException(String.format("Message Content column sequence id is wrong, expected:%d, but:%d", index, columnSeqID));
                }
                byte[] value = column.getValue().asBinary();
                stream.write(value, 0, value.length);
                ++index;
                ++currentCount;
                continue;
            }
            if (!name.equals(SYSTEM_COLUMN_NAME_PREFIX + this.columnNameOfMessageCrc32Suffix)) continue;
            crc32 = column.getValue().asLong();
        }
        if (columnCount != -1L && currentCount != columnCount) {
            throw new TimelineException(String.format("Message content column is broken, expected %d, but %d", columnCount, currentCount));
        }
        byte[] content = stream.toByteArray();
        try {
            stream.close();
        }
        catch (IOException iOException) {
            throw new TimelineException("Close ByteArrayOutputStream failed", iOException);
        }
        if (this.columnNameOfMessageCrc32Suffix != null && !this.columnNameOfMessageCrc32Suffix.isEmpty() && (l = TimelineMessageForV1.crc32(content)) != crc32) {
            throw new TimelineException(String.format("Message content is broken, expected crc32:%d, but:%d", crc32, l));
        }
        this.stringMessage = new String(content);
        return this.stringMessage;
    }

    public void addAttribute(String name, String value) {
        this.message.setField(name, value);
    }

    public String getAttribute(String name) {
        return this.message.getString(name);
    }

    public static long crc32(byte[] content) {
        CRC32 crc32 = new CRC32();
        crc32.update(content, 0, content.length);
        return crc32.getValue();
    }
}

