/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.delivery;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.delivery.EventColumn;
import com.alicloud.openservices.tablestore.model.delivery.OSSFileFormat;
import com.alicloud.openservices.tablestore.model.delivery.ParquetSchema;
import com.alicloud.openservices.tablestore.model.delivery.TimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OSSTaskConfig {
    private String ossPrefix;
    private TimeFormatter timeFormatter;
    private String ossBucket;
    private String ossEndpoint;
    private String ossStsRole;
    private EventColumn eventTimeColumn;
    private OSSFileFormat format;
    private List<ParquetSchema> parquetSchema = new ArrayList<ParquetSchema>();

    public OSSTaskConfig() {
        this.setTimeFormatter(TimeFormatter.YDMFormatter);
        this.setFormat(OSSFileFormat.Parquet);
    }

    public String getOssPrefix() {
        return this.ossPrefix;
    }

    public void setOssPrefix(String ossPrefix) {
        Preconditions.checkArgument(ossPrefix != null && !ossPrefix.isEmpty(), "the ossPrefix should not be null or empty");
        this.ossPrefix = ossPrefix;
    }

    public TimeFormatter getTimeFormatter() {
        return this.timeFormatter;
    }

    public void setTimeFormatter(TimeFormatter timeFormatter) {
        Preconditions.checkNotNull(timeFormatter);
        this.timeFormatter = timeFormatter;
    }

    public String getOssBucket() {
        return this.ossBucket;
    }

    public void setOssBucket(String ossBucket) {
        Preconditions.checkArgument(ossBucket != null && !ossBucket.isEmpty(), "the oss Bucket should not be null or empty");
        this.ossBucket = ossBucket;
    }

    public String getOssEndpoint() {
        return this.ossEndpoint;
    }

    public void setOssEndpoint(String ossEndpoint) {
        Preconditions.checkArgument(ossEndpoint != null && !ossEndpoint.isEmpty(), "the oss endpoint should not be null or empty");
        this.ossEndpoint = ossEndpoint;
    }

    public String getOssStsRole() {
        return this.ossStsRole;
    }

    public void setOssStsRole(String ossStsRole) {
        Preconditions.checkArgument(ossStsRole != null && !ossStsRole.isEmpty(), "the oss stsRole should not be null or empty");
        this.ossStsRole = ossStsRole;
    }

    public EventColumn getEventTimeColumn() {
        return this.eventTimeColumn;
    }

    public void setEventTimeColumn(EventColumn eventTimeColumn) {
        Preconditions.checkNotNull(eventTimeColumn);
        this.eventTimeColumn = eventTimeColumn;
    }

    public OSSFileFormat getFormat() {
        return this.format;
    }

    public void setFormat(OSSFileFormat format) {
        Preconditions.checkNotNull(format);
        this.format = format;
    }

    public List<ParquetSchema> getParquetSchemaList() {
        return Collections.unmodifiableList(this.parquetSchema);
    }

    public void addParquetSchema(ParquetSchema parquetSchema) {
        Preconditions.checkNotNull(parquetSchema);
        this.parquetSchema.add(parquetSchema);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append("ossPrefix: ").append(this.ossPrefix).append(", timeFormatter: ").append((Object)this.timeFormatter).append(", ossBucket: ").append(this.ossBucket).append(", ossEndpoint: ").append(this.ossEndpoint).append(", ossStsRole: ").append(this.ossStsRole).append(", eventTimeColumn: ").append(this.eventTimeColumn).append(", format: ").append(this.format.name()).append(", parquetSchema: ").append(this.parquetSchema);
        return sb.toString();
    }
}

