/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.model.Column;

public class RecordColumn
implements Jsonizable {
    private Column column;
    private ColumnType columnType;

    public RecordColumn(Column column, ColumnType columnType) {
        this.column = column;
        this.columnType = columnType;
    }

    public Column getColumn() {
        return this.column;
    }

    public ColumnType getColumnType() {
        return this.columnType;
    }

    public String toString() {
        return this.column.toString() + ",ColumnType:" + (Object)((Object)this.columnType);
    }

    public int hashCode() {
        return this.column.hashCode() ^ this.columnType.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RecordColumn)) {
            return false;
        }
        RecordColumn col = (RecordColumn)o;
        return this.column.equals(col.getColumn()) && this.columnType.equals((Object)col.getColumnType());
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        sb.append("{\"ColumnType\": \"");
        sb.append(this.columnType.toString());
        sb.append("\", \"Column\": ");
        this.column.jsonize(sb, newline + "  ");
        sb.append("}");
    }

    public static enum ColumnType {
        PUT,
        DELETE_ONE_VERSION,
        DELETE_ALL_VERSION;

    }
}

