/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.http;

import com.alicloud.openservices.tablestore.PartialResultFailedException;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.core.ResponseContentWithMeta;
import com.alicloud.openservices.tablestore.core.TraceLogger;
import com.alicloud.openservices.tablestore.core.http.ResponseConsumer;
import com.alicloud.openservices.tablestore.core.protocol.OtsInternalApi;
import com.alicloud.openservices.tablestore.core.protocol.ResponseFactory;
import com.alicloud.openservices.tablestore.core.protocol.ResultParser;
import com.alicloud.openservices.tablestore.core.utils.LogUtil;
import com.alicloud.openservices.tablestore.model.BatchGetRowResponse;
import com.alicloud.openservices.tablestore.model.Response;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import java.util.List;
import java.util.Map;

public class BatchGetRowResponseConsumer
extends ResponseConsumer<BatchGetRowResponse> {
    public BatchGetRowResponseConsumer(ResultParser resultParser, TraceLogger traceLogger, RetryStrategy retry, BatchGetRowResponse lastResult) {
        super(resultParser, traceLogger, retry, lastResult);
    }

    BatchGetRowResponse mergeResult(BatchGetRowResponse lastResult, BatchGetRowResponse result) {
        Response meta = new Response(result.getRequestId());
        meta.setTraceId(this.traceLogger.getTraceId());
        BatchGetRowResponse mergedResult = new BatchGetRowResponse(meta);
        Map<String, List<BatchGetRowResponse.RowResult>> lastRowResultMap = lastResult.getTableToRowsResult();
        Map<String, List<BatchGetRowResponse.RowResult>> rowResultMap = result.getTableToRowsResult();
        for (String tableName : lastRowResultMap.keySet()) {
            List<BatchGetRowResponse.RowResult> lastRowResultList = lastRowResultMap.get(tableName);
            List<BatchGetRowResponse.RowResult> rowResultList = rowResultMap.get(tableName);
            int idx = 0;
            for (BatchGetRowResponse.RowResult lastRowResult : lastRowResultList) {
                BatchGetRowResponse.RowResult rowResult;
                if (lastRowResult.isSucceed()) {
                    mergedResult.addResult(lastRowResult);
                    continue;
                }
                if ((rowResult = rowResultList.get(idx++)).isSucceed()) {
                    mergedResult.addResult(new BatchGetRowResponse.RowResult(tableName, rowResult.getRow(), rowResult.getConsumedCapacity(), lastRowResult.getIndex()));
                    continue;
                }
                mergedResult.addResult(new BatchGetRowResponse.RowResult(tableName, rowResult.getError(), lastRowResult.getIndex()));
            }
        }
        return mergedResult;
    }

    @Override
    protected BatchGetRowResponse parseResult() throws Exception {
        List<BatchGetRowResponse.RowResult> failedRows;
        ResponseContentWithMeta responseContent = this.getResponseContentWithMeta();
        OtsInternalApi.BatchGetRowResponse BatchGetRowResponse2 = (OtsInternalApi.BatchGetRowResponse)responseContent.getMessage();
        BatchGetRowResponse result = ResponseFactory.createBatchGetRowResponse(responseContent, BatchGetRowResponse2);
        if (this.lastResult != null) {
            result = this.mergeResult((BatchGetRowResponse)this.lastResult, result);
        }
        if ((failedRows = result.getFailedRows()).isEmpty()) {
            return result;
        }
        PartialResultFailedException partialEx = new PartialResultFailedException(null, result.getRequestId(), result);
        for (BatchGetRowResponse.RowResult rowResult : failedRows) {
            TableStoreException ex = new TableStoreException(rowResult.getError().getMessage(), null, rowResult.getError().getCode(), result.getRequestId(), 0);
            partialEx.addError(ex);
            LogUtil.logOnFailed(this.traceLogger, this.retry, ex, result.getRequestId());
        }
        throw partialEx;
    }
}

