/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.auth;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.auth.HttpCredentialsFetcher;
import com.alicloud.openservices.tablestore.core.auth.InstanceProfileCredentials;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;
import com.alicloud.openservices.tablestore.core.utils.HttpResponse;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceProfileCredentialsFetcher
extends HttpCredentialsFetcher {
    private Logger logger = LoggerFactory.getLogger(InstanceProfileCredentialsFetcher.class);
    private static final String URL_IN_ECS_METADATA = "/latest/meta-data/ram/security-credentials/";
    private static final String metadataServiceHost = "100.100.100.200";
    private String roleName;

    public void setRoleName(String roleName) {
        if (null == roleName || roleName.isEmpty()) {
            throw new IllegalArgumentException("You must specifiy a valid role name.");
        }
        this.roleName = roleName;
    }

    public InstanceProfileCredentialsFetcher withRoleName(String roleName) {
        this.setRoleName(roleName);
        return this;
    }

    @Override
    public URL buildUrl() throws ClientException {
        try {
            return new URL("http://100.100.100.200/latest/meta-data/ram/security-credentials/" + this.roleName);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    @Override
    public ServiceCredentials parse(HttpResponse response) throws ClientException {
        String jsonContent = new String(response.getHttpContent());
        try {
            MetadataResponse res = (MetadataResponse)new Gson().fromJson(jsonContent, MetadataResponse.class);
            if (res == null) {
                this.logger.error("Invalid response form ECS Metadata service: {}.", (Object)jsonContent);
                throw new ClientException("Invalid json got from ECS Metadata service.");
            }
            if (res.code == null || res.accessKeyId == null || res.accessKeySecret == null || res.securityToken == null || res.expiration == null) {
                this.logger.error("Invalid response form ECS Metadata service: {}.", (Object)jsonContent);
                throw new ClientException("Invalid json got from ECS Metadata service.");
            }
            if (!"Success".equalsIgnoreCase(res.code)) {
                this.logger.error("Failed to get RAM session credentials from ECS Metadata service: {}.", (Object)jsonContent);
                throw new ClientException("Failed to get RAM session credentials from ECS metadata service.");
            }
            return new InstanceProfileCredentials(res.accessKeyId, res.accessKeySecret, res.securityToken, res.expiration);
        }
        catch (Exception e) {
            throw new ClientException("InstanceProfileCredentialsFetcher.parse [" + jsonContent + "] exception:", e);
        }
    }

    private static class MetadataResponse {
        @SerializedName(value="Code")
        String code;
        @SerializedName(value="AccessKeyId")
        String accessKeyId;
        @SerializedName(value="AccessKeySecret")
        String accessKeySecret;
        @SerializedName(value="SecurityToken")
        String securityToken;
        @SerializedName(value="Expiration")
        String expiration;

        private MetadataResponse() {
        }
    }
}

