/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.CallSnapshot;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.StatsItem;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.StatsSnapshot;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class StatsItemSet {
    private final ConcurrentMap<String, StatsItem> statsItemTable = new ConcurrentHashMap<String, StatsItem>(128);
    private final String statsName;
    private final ScheduledExecutorService scheduledExecutorService;
    private final InternalLogger log;

    public StatsItemSet(String statsName, ScheduledExecutorService scheduledExecutorService, InternalLogger log) {
        this.statsName = statsName;
        this.scheduledExecutorService = scheduledExecutorService;
        this.log = log;
        this.init();
    }

    public void init() {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItemSet.this.samplingInSeconds();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, 0L, 10L, TimeUnit.SECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItemSet.this.samplingInMinutes();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, 0L, 10L, TimeUnit.MINUTES);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItemSet.this.samplingInHour();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, 0L, 1L, TimeUnit.HOURS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItemSet.this.printAtMinutes();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, Math.abs(UtilAll.computNextMinutesTimeMillis() - System.currentTimeMillis()), 60000L, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItemSet.this.printAtHour();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, Math.abs(UtilAll.computNextHourTimeMillis() - System.currentTimeMillis()), 3600000L, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItemSet.this.printAtDay();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, Math.abs(UtilAll.computNextMorningTimeMillis() - System.currentTimeMillis()), 86400000L, TimeUnit.MILLISECONDS);
    }

    private void samplingInSeconds() {
        for (Map.Entry next : this.statsItemTable.entrySet()) {
            ((StatsItem)next.getValue()).samplingInSeconds();
        }
    }

    private void samplingInMinutes() {
        Iterator it = this.statsItemTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            StatsItem statsItem = (StatsItem)next.getValue();
            statsItem.samplingInMinutes();
            LinkedList<CallSnapshot> csList = statsItem.getCsListHour();
            if (csList == null || csList.size() < 7) continue;
            CallSnapshot first = csList.getFirst();
            CallSnapshot last = csList.getLast();
            if (first.getTimes() != last.getTimes() || first.getValue() != last.getValue()) continue;
            it.remove();
        }
    }

    private void samplingInHour() {
        for (Map.Entry next : this.statsItemTable.entrySet()) {
            ((StatsItem)next.getValue()).samplingInHour();
        }
    }

    private void printAtMinutes() {
        for (Map.Entry next : this.statsItemTable.entrySet()) {
            ((StatsItem)next.getValue()).printAtMinutes();
        }
    }

    private void printAtHour() {
        for (Map.Entry next : this.statsItemTable.entrySet()) {
            ((StatsItem)next.getValue()).printAtHour();
        }
    }

    private void printAtDay() {
        for (Map.Entry next : this.statsItemTable.entrySet()) {
            ((StatsItem)next.getValue()).printAtDay();
        }
    }

    public void addValue(String statsKey, int incValue, int incTimes) {
        StatsItem statsItem = this.getAndCreateStatsItem(statsKey);
        statsItem.getValue().addAndGet(incValue);
        statsItem.getTimes().addAndGet(incTimes);
    }

    public StatsItem getAndCreateStatsItem(String statsKey) {
        StatsItem prev;
        StatsItem statsItem = (StatsItem)this.statsItemTable.get(statsKey);
        if (null != statsItem || null == (prev = this.statsItemTable.put(statsKey, statsItem = new StatsItem(this.statsName, statsKey, this.scheduledExecutorService, this.log)))) {
            // empty if block
        }
        return statsItem;
    }

    public StatsSnapshot getStatsDataInMinute(String statsKey) {
        StatsItem statsItem = (StatsItem)this.statsItemTable.get(statsKey);
        if (null != statsItem) {
            return statsItem.getStatsDataInMinute();
        }
        return new StatsSnapshot();
    }

    public StatsSnapshot getStatsDataInHour(String statsKey) {
        StatsItem statsItem = (StatsItem)this.statsItemTable.get(statsKey);
        if (null != statsItem) {
            return statsItem.getStatsDataInHour();
        }
        return new StatsSnapshot();
    }

    public StatsSnapshot getStatsDataInDay(String statsKey) {
        StatsItem statsItem = (StatsItem)this.statsItemTable.get(statsKey);
        if (null != statsItem) {
            return statsItem.getStatsDataInDay();
        }
        return new StatsSnapshot();
    }

    public StatsItem getStatsItem(String statsKey) {
        return (StatsItem)this.statsItemTable.get(statsKey);
    }
}

