/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ons.open.trace.core.dispatch.impl;

import com.alibaba.ons.open.trace.core.common.OnsTraceContext;
import com.alibaba.ons.open.trace.core.common.OnsTraceDataEncoder;
import com.alibaba.ons.open.trace.core.common.OnsTraceDispatcherType;
import com.alibaba.ons.open.trace.core.common.OnsTraceTransferBean;
import com.alibaba.ons.open.trace.core.dispatch.AsyncDispatcher;
import com.alibaba.ons.open.trace.core.dispatch.impl.TraceProducerFactory;
import com.aliyun.openservices.ons.api.impl.authority.SessionCredentials;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.common.ThreadLocalIndex;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.TopicPublishInfo;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.MessageQueueSelector;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendCallback;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.ThreadFactoryImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.NamespaceUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class AsyncArrayDispatcher
implements AsyncDispatcher {
    private static final InternalLogger CLIENT_LOG = ClientLogger.getLog();
    private final int queueSize;
    private final int batchSize;
    private final DefaultMQProducer traceProducer;
    private final ThreadPoolExecutor traceExecuter;
    private AtomicLong discardCount;
    private Thread worker;
    private ArrayBlockingQueue<OnsTraceContext> traceContextQueue;
    private ArrayBlockingQueue<Runnable> appenderQueue;
    private volatile Thread shutDownHook;
    private volatile boolean stopped = false;
    private String dispatcherType;
    private DefaultMQProducerImpl hostProducer;
    private DefaultMQPushConsumerImpl hostConsumer;
    private volatile ThreadLocalIndex sendWhichQueue = new ThreadLocalIndex();
    private String dispatcherId = UUID.randomUUID().toString();

    public AsyncArrayDispatcher(Properties properties) throws MQClientException {
        this.dispatcherType = properties.getProperty("DispatcherType");
        int queueSize = Integer.parseInt(properties.getProperty("AsyncBufferSize", "2048"));
        this.queueSize = queueSize = 1 << 32 - Integer.numberOfLeadingZeros(queueSize - 1);
        this.batchSize = Integer.parseInt(properties.getProperty("MaxBatchNum", "1"));
        this.discardCount = new AtomicLong(0L);
        this.traceContextQueue = new ArrayBlockingQueue(1024);
        this.appenderQueue = new ArrayBlockingQueue(queueSize);
        this.traceExecuter = new ThreadPoolExecutor(10, 20, 60000L, TimeUnit.MILLISECONDS, this.appenderQueue, new ThreadFactoryImpl("MQTraceSendThread_"));
        this.traceProducer = TraceProducerFactory.getTraceDispatcherProducer(properties);
    }

    public AsyncArrayDispatcher(Properties properties, SessionCredentials sessionCredentials) throws MQClientException {
        this.dispatcherType = properties.getProperty("DispatcherType");
        int queueSize = Integer.parseInt(properties.getProperty("AsyncBufferSize", "2048"));
        this.queueSize = queueSize = 1 << 32 - Integer.numberOfLeadingZeros(queueSize - 1);
        this.batchSize = Integer.parseInt(properties.getProperty("MaxBatchNum", "1"));
        this.discardCount = new AtomicLong(0L);
        this.traceContextQueue = new ArrayBlockingQueue(1024);
        this.appenderQueue = new ArrayBlockingQueue(queueSize);
        this.traceExecuter = new ThreadPoolExecutor(10, 20, 60000L, TimeUnit.MILLISECONDS, this.appenderQueue, new ThreadFactoryImpl("MQTraceSendThread_"));
        this.traceProducer = TraceProducerFactory.getTraceDispatcherProducer(properties, sessionCredentials);
    }

    public DefaultMQProducerImpl getHostProducer() {
        return this.hostProducer;
    }

    public void setHostProducer(DefaultMQProducerImpl hostProducer) {
        this.hostProducer = hostProducer;
    }

    public DefaultMQPushConsumerImpl getHostConsumer() {
        return this.hostConsumer;
    }

    public void setHostConsumer(DefaultMQPushConsumerImpl hostConsumer) {
        this.hostConsumer = hostConsumer;
    }

    @Override
    public void start() throws MQClientException {
        TraceProducerFactory.registerTraceDispatcher(this.dispatcherId);
        this.worker = new ThreadFactoryImpl("MQ-AsyncArrayDispatcher-Thread-" + this.dispatcherId, true).newThread(new AsyncRunnable());
        this.worker.start();
        this.registerShutDownHook();
    }

    @Override
    public boolean append(Object ctx) {
        boolean result = this.traceContextQueue.offer((OnsTraceContext)ctx);
        if (!result) {
            CLIENT_LOG.info("buffer full" + this.discardCount.incrementAndGet() + " ,context is " + ctx);
        }
        return result;
    }

    @Override
    public void flush() throws IOException {
        long end = System.currentTimeMillis() + 500L;
        while (this.traceContextQueue.size() > 0 || this.appenderQueue.size() > 0 && System.currentTimeMillis() <= end) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        CLIENT_LOG.info("------end trace send " + this.traceContextQueue.size() + "   " + this.appenderQueue.size());
    }

    @Override
    public void shutdown() {
        this.stopped = true;
        this.traceExecuter.shutdown();
        TraceProducerFactory.unregisterTraceDispatcher(this.dispatcherId);
        this.removeShutdownHook();
    }

    public void registerShutDownHook() {
        if (this.shutDownHook == null) {
            this.shutDownHook = new ThreadFactoryImpl("ShutdownHookMQTrace").newThread(new Runnable(){
                private volatile boolean hasShutdown = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (!this.hasShutdown) {
                            try {
                                AsyncArrayDispatcher.this.flush();
                            }
                            catch (IOException e) {
                                CLIENT_LOG.error("system mqtrace hook shutdown failed ,maybe loss some trace data");
                            }
                        }
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutDownHook);
        }
    }

    public void removeShutdownHook() {
        if (this.shutDownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
        }
    }

    class AsyncAppenderRequest
    implements Runnable {
        List<OnsTraceContext> contextList;

        public AsyncAppenderRequest(List<OnsTraceContext> contextList) {
            this.contextList = contextList != null ? contextList : new ArrayList<OnsTraceContext>(1);
        }

        @Override
        public void run() {
            this.sendTraceData(this.contextList);
        }

        public void sendTraceData(List<OnsTraceContext> contextList) {
            HashMap transBeanMap = new HashMap(16);
            String currentRegionId = null;
            for (OnsTraceContext onsTraceContext : contextList) {
                currentRegionId = onsTraceContext.getRegionId();
                if (currentRegionId == null || onsTraceContext.getTraceBeans().isEmpty()) continue;
                String topic = onsTraceContext.getTraceBeans().get(0).getTopic();
                String key = topic + '\u0001' + currentRegionId;
                ArrayList<OnsTraceTransferBean> transBeanList = (ArrayList<OnsTraceTransferBean>)transBeanMap.get(key);
                if (transBeanList == null) {
                    transBeanList = new ArrayList<OnsTraceTransferBean>();
                    transBeanMap.put(key, transBeanList);
                }
                OnsTraceTransferBean traceData = OnsTraceDataEncoder.encoderFromContextBean(onsTraceContext);
                transBeanList.add(traceData);
            }
            for (Map.Entry entry : transBeanMap.entrySet()) {
                String[] key = ((String)entry.getKey()).split(String.valueOf('\u0001'));
                this.flushData((List)entry.getValue(), key[0], key[1]);
            }
        }

        private void flushData(List<OnsTraceTransferBean> transBeanList, String topic, String currentRegionId) {
            if (transBeanList.size() == 0) {
                return;
            }
            StringBuilder buffer = new StringBuilder(1024);
            int count = 0;
            HashSet<String> keySet = new HashSet<String>();
            for (OnsTraceTransferBean bean : transBeanList) {
                keySet.addAll(bean.getTransKey());
                buffer.append(bean.getTransData());
                ++count;
                if (buffer.length() < AsyncArrayDispatcher.this.traceProducer.getMaxMessageSize()) continue;
                this.sendTraceDataByMQ(keySet, buffer.toString(), topic, currentRegionId);
                buffer.delete(0, buffer.length());
                keySet.clear();
                count = 0;
            }
            if (count > 0) {
                this.sendTraceDataByMQ(keySet, buffer.toString(), topic, currentRegionId);
            }
            transBeanList.clear();
        }

        private void sendTraceDataByMQ(Set<String> keySet, final String data, String dataTopic, String currentRegionId) {
            String topic = "rmq_sys_TRACE_DATA_" + currentRegionId;
            Message message = new Message(topic, data.getBytes());
            message.setKeys(keySet);
            try {
                Set<String> dataBrokerSet = this.getBrokerSetByTopic(dataTopic);
                Set<String> traceBrokerSet = this.tryGetMessageQueueBrokerSet(AsyncArrayDispatcher.this.traceProducer.getDefaultMQProducerImpl(), topic);
                dataBrokerSet.retainAll(traceBrokerSet);
                SendCallback callback = new SendCallback(){

                    @Override
                    public void onSuccess(SendResult sendResult) {
                    }

                    @Override
                    public void onException(Throwable e) {
                        CLIENT_LOG.info("send trace data ,the traceData is " + data);
                    }
                };
                if (dataBrokerSet.isEmpty()) {
                    AsyncArrayDispatcher.this.traceProducer.send(message, callback, 5000L);
                } else {
                    AsyncArrayDispatcher.this.traceProducer.send(message, new MessageQueueSelector(){

                        @Override
                        public MessageQueue select(List<MessageQueue> mqs, Message msg, Object arg) {
                            Set brokerSet = (Set)arg;
                            ArrayList<MessageQueue> filterMqs = new ArrayList<MessageQueue>();
                            for (MessageQueue queue : mqs) {
                                if (!brokerSet.contains(queue.getBrokerName())) continue;
                                filterMqs.add(queue);
                            }
                            int index = AsyncArrayDispatcher.this.sendWhichQueue.getAndIncrement();
                            int pos = Math.abs(index) % filterMqs.size();
                            if (pos < 0) {
                                pos = 0;
                            }
                            return (MessageQueue)filterMqs.get(pos);
                        }
                    }, dataBrokerSet, callback);
                }
            }
            catch (Exception e) {
                CLIENT_LOG.info("send trace data,the traceData is" + data);
            }
        }

        private Set<String> getBrokerSetByTopic(String topic) {
            Set<String> brokerSet = new HashSet<String>();
            if (AsyncArrayDispatcher.this.dispatcherType != null && AsyncArrayDispatcher.this.dispatcherType.equals(OnsTraceDispatcherType.PRODUCER.name()) && AsyncArrayDispatcher.this.hostProducer != null) {
                brokerSet = this.tryGetMessageQueueBrokerSet(AsyncArrayDispatcher.this.hostProducer, topic);
            }
            if (AsyncArrayDispatcher.this.dispatcherType != null && AsyncArrayDispatcher.this.dispatcherType.equals(OnsTraceDispatcherType.CONSUMER.name()) && AsyncArrayDispatcher.this.hostConsumer != null) {
                brokerSet = this.tryGetMessageQueueBrokerSet(AsyncArrayDispatcher.this.hostConsumer, topic);
            }
            return brokerSet;
        }

        private Set<String> tryGetMessageQueueBrokerSet(DefaultMQProducerImpl producer, String topic) {
            HashSet<String> brokerSet = new HashSet<String>();
            String realTopic = NamespaceUtil.wrapNamespace(producer.getDefaultMQProducer().getNamespace(), topic);
            TopicPublishInfo topicPublishInfo = (TopicPublishInfo)producer.getTopicPublishInfoTable().get(realTopic);
            if (null == topicPublishInfo || !topicPublishInfo.ok()) {
                producer.getTopicPublishInfoTable().putIfAbsent(realTopic, new TopicPublishInfo());
                producer.getmQClientFactory().updateTopicRouteInfoFromNameServer(realTopic);
                topicPublishInfo = (TopicPublishInfo)producer.getTopicPublishInfoTable().get(realTopic);
            }
            if (topicPublishInfo.isHaveTopicRouterInfo() || topicPublishInfo.ok()) {
                for (MessageQueue queue : topicPublishInfo.getMessageQueueList()) {
                    brokerSet.add(queue.getBrokerName());
                }
            }
            return brokerSet;
        }

        private Set<String> tryGetMessageQueueBrokerSet(DefaultMQPushConsumerImpl consumer, String topic) {
            HashSet<String> brokerSet = new HashSet<String>();
            try {
                String realTopic = NamespaceUtil.wrapNamespace(consumer.getDefaultMQPushConsumer().getNamespace(), topic);
                Set<MessageQueue> messageQueues = consumer.fetchSubscribeMessageQueues(realTopic);
                for (MessageQueue queue : messageQueues) {
                    brokerSet.add(queue.getBrokerName());
                }
            }
            catch (MQClientException e) {
                CLIENT_LOG.info("fetch message queue failed, the topic is {}", (Object)topic);
            }
            return brokerSet;
        }
    }

    class AsyncRunnable
    implements Runnable {
        private boolean stopped;

        AsyncRunnable() {
        }

        @Override
        public void run() {
            while (!this.stopped) {
                ArrayList<OnsTraceContext> contexts = new ArrayList<OnsTraceContext>(AsyncArrayDispatcher.this.batchSize);
                for (int i = 0; i < AsyncArrayDispatcher.this.batchSize; ++i) {
                    OnsTraceContext context = null;
                    try {
                        context = (OnsTraceContext)AsyncArrayDispatcher.this.traceContextQueue.poll(5L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (context == null) break;
                    contexts.add(context);
                }
                if (contexts.size() > 0) {
                    AsyncAppenderRequest request = new AsyncAppenderRequest(contexts);
                    AsyncArrayDispatcher.this.traceExecuter.submit(request);
                    continue;
                }
                if (!AsyncArrayDispatcher.this.stopped) continue;
                this.stopped = true;
            }
        }
    }
}

