/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.vod.model.v20170321;

import com.aliyuncs.RpcAcsRequest;

/**
 * @author auto create
 * @version 
 */
public class GetVideoPlayAuthRequest extends RpcAcsRequest<GetVideoPlayAuthResponse> {
	
	public GetVideoPlayAuthRequest() {
		super("vod", "2017-03-21", "GetVideoPlayAuth", "vod");
	}

	private Long resourceOwnerId;

	private String resourceOwnerAccount;

	private String playConfig;

	private Long authInfoTimeout;

	private String videoId;

	private Long ownerId;

	public Long getResourceOwnerId() {
		return this.resourceOwnerId;
	}

	public void setResourceOwnerId(Long resourceOwnerId) {
		this.resourceOwnerId = resourceOwnerId;
		if(resourceOwnerId != null){
			putQueryParameter("ResourceOwnerId", resourceOwnerId.toString());
		}
	}

	public String getResourceOwnerAccount() {
		return this.resourceOwnerAccount;
	}

	public void setResourceOwnerAccount(String resourceOwnerAccount) {
		this.resourceOwnerAccount = resourceOwnerAccount;
		if(resourceOwnerAccount != null){
			putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
		}
	}

	public String getPlayConfig() {
		return this.playConfig;
	}

	public void setPlayConfig(String playConfig) {
		this.playConfig = playConfig;
		if(playConfig != null){
			putQueryParameter("PlayConfig", playConfig);
		}
	}

	public Long getAuthInfoTimeout() {
		return this.authInfoTimeout;
	}

	public void setAuthInfoTimeout(Long authInfoTimeout) {
		this.authInfoTimeout = authInfoTimeout;
		if(authInfoTimeout != null){
			putQueryParameter("AuthInfoTimeout", authInfoTimeout.toString());
		}
	}

	public String getVideoId() {
		return this.videoId;
	}

	public void setVideoId(String videoId) {
		this.videoId = videoId;
		if(videoId != null){
			putQueryParameter("VideoId", videoId);
		}
	}

	public Long getOwnerId() {
		return this.ownerId;
	}

	public void setOwnerId(Long ownerId) {
		this.ownerId = ownerId;
		if(ownerId != null){
			putQueryParameter("OwnerId", ownerId.toString());
		}
	}

	@Override
	public Class<GetVideoPlayAuthResponse> getResponseClass() {
		return GetVideoPlayAuthResponse.class;
	}

}
