/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.boot.flexible.processor;

import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.sofa.tracer.boot.flexible.processor.MethodInvocationProcessor;
import com.alipay.sofa.tracer.plugin.flexible.annotations.Tracer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.IntroductionInterceptor;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotationUtils;

public class SofaTracerIntroductionInterceptor
implements IntroductionInterceptor {
    private final MethodInvocationProcessor sofaMethodInvocationProcessor;

    public SofaTracerIntroductionInterceptor(MethodInvocationProcessor sofaMethodInvocationProcessor) {
        this.sofaMethodInvocationProcessor = sofaMethodInvocationProcessor;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (method == null) {
            return invocation.proceed();
        }
        Method mostSpecificMethod = AopUtils.getMostSpecificMethod((Method)method, invocation.getThis().getClass());
        Tracer tracerSpan = this.findAnnotation(mostSpecificMethod, Tracer.class);
        if (tracerSpan == null) {
            return invocation.proceed();
        }
        return this.sofaMethodInvocationProcessor.process(invocation, tracerSpan);
    }

    public boolean implementsInterface(Class<?> aClass) {
        return true;
    }

    private <T extends Annotation> T findAnnotation(Method method, Class<T> clazz) {
        Annotation annotation = AnnotationUtils.findAnnotation((Method)method, clazz);
        if (annotation == null) {
            try {
                annotation = AnnotationUtils.findAnnotation((Method)method.getDeclaringClass().getMethod(method.getName(), method.getParameterTypes()), clazz);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                SelfLog.warn((String)"Exception occurred while tyring to find the annotation");
            }
        }
        return (T)annotation;
    }
}

