/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.boot.flexible.aop;

import com.alipay.sofa.tracer.plugin.flexible.annotations.Tracer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.support.DynamicMethodMatcherPointcut;
import org.springframework.aop.support.annotation.AnnotationClassFilter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class TracerAnnotationClassPointcut
extends DynamicMethodMatcherPointcut {
    public boolean matches(Method method, Class<?> aClass, Object ... objects) {
        return true;
    }

    public ClassFilter getClassFilter() {
        return clazz -> new AnnotationClassOrMethodFilter(Tracer.class).matches(clazz);
    }

    private static class AnnotationMethodsResolver {
        private final Class<? extends Annotation> annotationType;

        AnnotationMethodsResolver(Class<? extends Annotation> annotationType) {
            this.annotationType = annotationType;
        }

        boolean hasAnnotatedMethods(Class<?> clazz) {
            AtomicBoolean found = new AtomicBoolean(false);
            ReflectionUtils.doWithMethods(clazz, method -> {
                if (found.get()) {
                    return;
                }
                Annotation annotation = AnnotationUtils.findAnnotation((Method)method, this.annotationType);
                if (annotation != null) {
                    found.set(true);
                }
            });
            return found.get();
        }
    }

    private final class AnnotationClassOrMethodFilter
    extends AnnotationClassFilter {
        private final AnnotationMethodsResolver methodsResolver;

        AnnotationClassOrMethodFilter(Class<? extends Annotation> annotationType) {
            super(annotationType, true);
            this.methodsResolver = new AnnotationMethodsResolver(annotationType);
        }

        public boolean matches(Class<?> clazz) {
            return super.matches(clazz) || this.methodsResolver.hasAnnotatedMethods(clazz);
        }
    }
}

