/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.boot.datasource.processor;

import com.alipay.common.tracer.core.utils.ReflectionUtils;
import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.sofa.tracer.plugins.datasource.SmartDataSource;
import com.alipay.sofa.tracer.plugins.datasource.utils.DataSourceUtils;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class DataSourceBeanPostProcessor
implements BeanPostProcessor,
EnvironmentAware,
PriorityOrdered {
    private Environment environment;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        String url;
        String getUrlMethodName;
        if (beanName.startsWith("s_t_d_s_") || bean instanceof SmartDataSource || !(bean instanceof DataSource)) {
            return bean;
        }
        if (DataSourceUtils.isDruidDataSource((Object)bean) || DataSourceUtils.isDbcpDataSource((Object)bean) || DataSourceUtils.isTomcatDataSource((Object)bean)) {
            getUrlMethodName = "getUrl";
        } else if (DataSourceUtils.isC3p0DataSource((Object)bean) || DataSourceUtils.isHikariDataSource((Object)bean)) {
            getUrlMethodName = "getJdbcUrl";
        } else {
            return bean;
        }
        try {
            Method urlMethod = ReflectionUtils.findMethod(bean.getClass(), (String)getUrlMethodName, (Class[])new Class[0]);
            urlMethod.setAccessible(true);
            url = (String)urlMethod.invoke(bean, new Object[0]);
        }
        catch (Throwable throwable) {
            throw new BeanCreationException(String.format("Can not find method: %s in class %s.", getUrlMethodName, bean.getClass().getCanonicalName()), throwable);
        }
        SmartDataSource proxiedDataSource = new SmartDataSource((DataSource)bean);
        String appName = this.environment.getProperty("spring.application.name");
        Assert.isTrue((!StringUtils.isBlank((String)appName) ? 1 : 0) != 0, (String)"spring.application.name must be configured!");
        proxiedDataSource.setAppName(appName);
        proxiedDataSource.setDbType(DataSourceUtils.resolveDbTypeFromUrl((String)url));
        proxiedDataSource.setDatabase(DataSourceUtils.resolveDatabaseFromUrl((String)url));
        proxiedDataSource.init();
        return proxiedDataSource;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

