/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.task.listener;

import com.alipay.sofa.registry.task.TaskClosure;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TaskEvent {
    private Object eventObj;
    private TaskType taskType;
    private long sendTimeStamp;
    private long createTime;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private TaskClosure taskClosure;

    public TaskEvent(TaskType taskType) {
        this.taskType = taskType;
        this.createTime = System.currentTimeMillis();
    }

    public TaskEvent(Object eventObj, TaskType taskType) {
        this.eventObj = eventObj;
        this.taskType = taskType;
    }

    public Object getEventObj() {
        return this.eventObj;
    }

    public void setEventObj(Object eventObj) {
        this.eventObj = eventObj;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    public TaskClosure getTaskClosure() {
        return this.taskClosure;
    }

    public void setTaskClosure(TaskClosure taskClosure) {
        this.taskClosure = taskClosure;
    }

    public long getSendTimeStamp() {
        return this.sendTimeStamp;
    }

    public void setSendTimeStamp(long sendTimeStamp) {
        this.sendTimeStamp = sendTimeStamp;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public String toString() {
        return "TaskEvent{eventObj=" + this.eventObj + ", sendTimeStamp=" + this.sendTimeStamp + ", attributes=" + this.attributes + '}';
    }

    public static enum TaskType {
        SUBSCRIBER_REGISTER_FETCH_TASK("SubscriberRegisterFetchTask"),
        SUBSCRIBER_PUSH_EMPTY_TASK("SubscriberPushEmptyTask"),
        WATCHER_REGISTER_FETCH_TASK("WatcherRegisterFetchTask"),
        DATA_CHANGE_FETCH_TASK("DataChangeFetchTask"),
        DATA_PUSH_TASK("DataPushTask"),
        DATA_CHANGE_FETCH_CLOUD_TASK("DataChangeFetchCloudTask"),
        RECEIVED_DATA_MULTI_PUSH_TASK("ReceivedDataMultiPushTask"),
        RECEIVED_DATA_CONFIG_PUSH_TASK("ReceivedDataConfigPushTask"),
        CANCEL_DATA_TASK("CancelDataTask"),
        SYNC_PUBLISHER_TASK("SyncPublisherTask"),
        SYNC_SUBSCRIBER_TASK("SyncSubscriberTask"),
        SESSION_REGISTER_DATA_TASK("SessionRegisterDataTask"),
        PROVIDE_DATA_CHANGE_FETCH_TASK("ProvideDataChangeFetchTask"),
        SUBSCRIBER_MULTI_FETCH_TASK("SubscriberMultiFetchTask"),
        USER_DATA_ELEMENT_PUSH_TASK("UserDataElementPushTask"),
        USER_DATA_ELEMENT_MULTI_PUSH_TASK("UserDataElementMultiPushTask"),
        SESSION_NODE_CHANGE_PUSH_TASK("SessionNodeChangePushTask"),
        DATA_NODE_CHANGE_PUSH_TASK("DataNodeChangePushTask"),
        RECEIVE_STATUS_CONFIRM_NOTIFY_TASK("ReceiveStatusConfirmNotifyTask"),
        PERSISTENCE_DATA_CHANGE_NOTIFY_TASK("PersistenceDataChangeNotifyTask");

        private String name;

        private TaskType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

