/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventListener;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.ConnectionManager;
import com.alipay.remoting.NamedThreadFactory;
import com.alipay.remoting.ReconnectManager;
import com.alipay.remoting.config.switches.GlobalSwitch;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.util.RemotingUtil;
import com.alipay.remoting.util.StringUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.Attribute;
import java.net.SocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

@ChannelHandler.Sharable
public class ConnectionEventHandler
extends ChannelDuplexHandler {
    private static final Logger logger = BoltLoggerFactory.getLogger("ConnectionEvent");
    private ConnectionManager connectionManager;
    private ConnectionEventListener eventListener;
    private ConnectionEventExecutor eventExecutor;
    private ReconnectManager reconnectManager;
    private GlobalSwitch globalSwitch;

    public ConnectionEventHandler() {
    }

    public ConnectionEventHandler(GlobalSwitch globalSwitch) {
        this.globalSwitch = globalSwitch;
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        if (logger.isInfoEnabled()) {
            String remote;
            String local = localAddress == null ? null : RemotingUtil.parseSocketAddressToString(localAddress);
            String string = remote = remoteAddress == null ? "UNKNOWN" : RemotingUtil.parseSocketAddressToString(remoteAddress);
            if (local == null) {
                if (logger.isInfoEnabled()) {
                    logger.info("Try connect to {}", (Object)remote);
                }
            } else if (logger.isInfoEnabled()) {
                logger.info("Try connect from {} to {}", (Object)local, (Object)remote);
            }
        }
        super.connect(ctx, remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.infoLog("Connection disconnect to {}", RemotingUtil.parseRemoteAddress(ctx.channel()));
        super.disconnect(ctx, promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.infoLog("Connection closed: {}", RemotingUtil.parseRemoteAddress(ctx.channel()));
        Connection conn = (Connection)ctx.channel().attr(Connection.CONNECTION).get();
        if (conn != null) {
            conn.onClose();
        }
        super.close(ctx, promise);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.infoLog("Connection channel registered: {}", RemotingUtil.parseRemoteAddress(ctx.channel()));
        super.channelRegistered(ctx);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.infoLog("Connection channel unregistered: {}", RemotingUtil.parseRemoteAddress(ctx.channel()));
        super.channelUnregistered(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.infoLog("Connection channel active: {}", RemotingUtil.parseRemoteAddress(ctx.channel()));
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        String remoteAddress = RemotingUtil.parseRemoteAddress(ctx.channel());
        this.infoLog("Connection channel inactive: {}", remoteAddress);
        super.channelInactive(ctx);
        Attribute attr = ctx.channel().attr(Connection.CONNECTION);
        if (null != attr) {
            if (this.globalSwitch != null && this.globalSwitch.isOn(0)) {
                Connection conn = (Connection)attr.get();
                if (this.reconnectManager != null) {
                    this.reconnectManager.addReconnectTask(conn.getUrl());
                }
            }
            this.onEvent((Connection)attr.get(), remoteAddress, ConnectionEventType.CLOSE);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        block6: {
            block5: {
                if (!(event instanceof ConnectionEventType)) break block5;
                switch ((ConnectionEventType)((Object)event)) {
                    case CONNECT: {
                        Channel channel = ctx.channel();
                        if (null != channel) {
                            Connection connection = (Connection)channel.attr(Connection.CONNECTION).get();
                            this.onEvent(connection, connection.getUrl().getOriginUrl(), ConnectionEventType.CONNECT);
                        } else {
                            logger.warn("channel null when handle user triggered event in ConnectionEventHandler!");
                        }
                        break block6;
                    }
                    default: {
                        return;
                    }
                }
            }
            super.userEventTriggered(ctx, event);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        String remoteAddress = RemotingUtil.parseRemoteAddress(ctx.channel());
        String localAddress = RemotingUtil.parseLocalAddress(ctx.channel());
        logger.warn("ExceptionCaught in connection: local[{}], remote[{}], close the connection! Cause[{}:{}]", new Object[]{localAddress, remoteAddress, cause.getClass().getSimpleName(), cause.getMessage()});
        ctx.channel().close();
    }

    private void onEvent(final Connection conn, final String remoteAddress, final ConnectionEventType type) {
        if (this.eventListener != null) {
            this.eventExecutor.onEvent(new Runnable(){

                @Override
                public void run() {
                    ConnectionEventHandler.this.eventListener.onEvent(type, remoteAddress, conn);
                }
            });
        }
    }

    public ConnectionEventListener getConnectionEventListener() {
        return this.eventListener;
    }

    public void setConnectionEventListener(ConnectionEventListener listener) {
        if (listener != null) {
            this.eventListener = listener;
            if (this.eventExecutor == null) {
                this.eventExecutor = new ConnectionEventExecutor();
            }
        }
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void setReconnectManager(ReconnectManager reconnectManager) {
        this.reconnectManager = reconnectManager;
    }

    private void infoLog(String format, String addr) {
        if (logger.isInfoEnabled()) {
            if (StringUtils.isNotEmpty(addr)) {
                logger.info(format, (Object)addr);
            } else {
                logger.info(format, (Object)"UNKNOWN-ADDR");
            }
        }
    }

    public class ConnectionEventExecutor {
        Logger logger = BoltLoggerFactory.getLogger("CommonDefault");
        ExecutorService executor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10000), new NamedThreadFactory("Bolt-conn-event-executor", true));

        public void onEvent(Runnable event) {
            try {
                this.executor.execute(event);
            }
            catch (Throwable t) {
                this.logger.error("Exception caught when execute connection event!", t);
            }
        }
    }
}

