/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.easysdk.kms.aliyun.credentials.provider;

import com.alipay.easysdk.kms.aliyun.credentials.EcsRamRoleCredentials;
import com.alipay.easysdk.kms.aliyun.credentials.ICredentials;
import com.alipay.easysdk.kms.aliyun.credentials.exceptions.CredentialException;
import com.alipay.easysdk.kms.aliyun.credentials.provider.ECSMetadataServiceCredentialsFetcher;
import com.alipay.easysdk.kms.aliyun.credentials.provider.ICredentialsProvider;

public class EcsRamRoleCredentialsProvider
implements ICredentialsProvider {
    private static final int MAX_ECS_METADATA_FETCH_RETRY_TIMES = 3;
    private final String roleName;
    private EcsRamRoleCredentials credentials = null;
    private ECSMetadataServiceCredentialsFetcher fetcher;

    public EcsRamRoleCredentialsProvider(String roleName) {
        if (null == roleName) {
            throw new NullPointerException("You must specifiy a valid role name.");
        }
        this.roleName = roleName;
        this.fetcher = new ECSMetadataServiceCredentialsFetcher();
        this.fetcher.setRoleName(this.roleName);
    }

    public EcsRamRoleCredentialsProvider withFetcher(ECSMetadataServiceCredentialsFetcher fetcher) {
        this.fetcher = fetcher;
        this.fetcher.setRoleName(this.roleName);
        return this;
    }

    @Override
    public ICredentials getCredentials() throws CredentialException {
        if (this.credentials == null || this.credentials.isExpired()) {
            this.credentials = this.fetcher.fetch(3);
        } else if (this.credentials.willSoonExpire() && this.credentials.shouldRefresh()) {
            try {
                this.credentials = this.fetcher.fetch();
            }
            catch (CredentialException e) {
                this.credentials.setLastFailedRefreshTime();
            }
        }
        return this.credentials;
    }
}

