/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.agent.handler.test;

import agent.org.objectweb.asm.Label;
import agent.org.objectweb.asm.tree.AnnotationNode;
import agent.org.objectweb.asm.tree.InsnList;
import agent.org.objectweb.asm.tree.InsnNode;
import agent.org.objectweb.asm.tree.LabelNode;
import agent.org.objectweb.asm.tree.LocalVariableNode;
import agent.org.objectweb.asm.tree.MethodNode;
import com.alibaba.testable.agent.handler.test.Framework;
import com.alibaba.testable.agent.model.TestCaseMethodType;
import com.alibaba.testable.agent.util.ClassUtil;
import java.util.Collections;
import java.util.Set;

public class SpockFramework
implements Framework {
    public static final String ANNOTATION_TEST = "Lorg/spockframework/runtime/model/FeatureMetadata;";
    private static final String NAME_CLEANUP = "cleanup";
    private static final String DESC_CLEANUP = "()Ljava/lang/Object;";

    @Override
    public boolean fit(Set<String> classAnnotations, Set<String> methodAnnotations) {
        return methodAnnotations.contains(ANNOTATION_TEST);
    }

    @Override
    public TestCaseMethodType checkMethodType(MethodNode mn) {
        if (NAME_CLEANUP.equals(mn.name)) {
            return TestCaseMethodType.AFTER_TEST;
        }
        if (mn.visibleAnnotations == null) {
            return TestCaseMethodType.OTHERS;
        }
        for (AnnotationNode an : mn.visibleAnnotations) {
            if (!ANNOTATION_TEST.equals(an.desc)) continue;
            return TestCaseMethodType.TEST;
        }
        return TestCaseMethodType.OTHERS;
    }

    @Override
    public MethodNode getCleanupMethod(String className) {
        MethodNode cleanupMethod = new MethodNode(2, NAME_CLEANUP, DESC_CLEANUP, null, null);
        InsnList il = new InsnList();
        LabelNode startLabel = new LabelNode(new Label());
        LabelNode endLabel = new LabelNode(new Label());
        il.add(startLabel);
        il.add(new InsnNode(1));
        il.add(new InsnNode(176));
        il.add(endLabel);
        cleanupMethod.instructions = il;
        cleanupMethod.localVariables = Collections.singletonList(new LocalVariableNode("this", ClassUtil.toByteCodeClassName(className), null, startLabel, endLabel, 0));
        cleanupMethod.maxLocals = 1;
        cleanupMethod.maxStack = 1;
        return cleanupMethod;
    }
}

