/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.agent.handler;

import agent.org.objectweb.asm.Label;
import agent.org.objectweb.asm.tree.AnnotationNode;
import agent.org.objectweb.asm.tree.ClassNode;
import agent.org.objectweb.asm.tree.InsnList;
import agent.org.objectweb.asm.tree.InsnNode;
import agent.org.objectweb.asm.tree.LabelNode;
import agent.org.objectweb.asm.tree.LocalVariableNode;
import agent.org.objectweb.asm.tree.MethodInsnNode;
import agent.org.objectweb.asm.tree.MethodNode;
import agent.org.objectweb.asm.tree.VarInsnNode;
import com.alibaba.testable.agent.handler.BaseClassHandler;
import com.alibaba.testable.agent.util.ClassUtil;
import com.alibaba.testable.core.util.CollectionUtil;
import java.util.List;

public class OmniClassHandler
extends BaseClassHandler {
    private static final String VOID_TYPE = "java/lang/Void";
    private static final String IGNORE = "ignore";
    private static final String METHOD_START = "(";
    private static final String VOID_METHOD_END = ")V";
    private static final String VOID_METHOD = "()V";
    private static final String ENABLE_CONFIGURATION = "Lorg/springframework/context/annotation/Configuration;";
    private static final String CLASS_ABSTRACT_COLLECTION = "java/util/AbstractCollection";
    private static final String CLASS_NUMBER = "java/lang/Number";
    private static final String CLASS_HASH_SET = "java/util/HashSet";
    private static final String[] JUNIT_TEST_ANNOTATIONS = new String[]{"Lorg/junit/Test;", "Lorg/junit/jupiter/api/Test;", "Lorg/junit/jupiter/params/ParameterizedTest;"};
    private static final String[] UNREACHABLE_CLASSES = new String[]{"java/util/AbstractCollection", "java/lang/Number", "java/util/HashSet"};

    @Override
    protected void transform(ClassNode cn) {
        if (this.isInterfaceOrAtom(cn) || this.isJunitTestClass(cn) || this.isUninstantiableClass(cn) || this.hasSpecialAnnotation(cn)) {
            return;
        }
        this.addConstructorWithVoidTypeParameter(cn);
    }

    private void addConstructorWithVoidTypeParameter(ClassNode cn) {
        MethodNode constructor = new MethodNode(1, "<init>", METHOD_START + ClassUtil.toByteCodeClassName(VOID_TYPE) + VOID_METHOD_END, null, null);
        LabelNode start = new LabelNode(new Label());
        LabelNode end = new LabelNode(new Label());
        if (cn.superName.equals("java/lang/Object")) {
            constructor.instructions = this.invokeSuperWithoutParameter(start, end);
            constructor.localVariables = this.createLocalVariables(cn, start, end);
            constructor.maxStack = 1;
        } else {
            constructor.instructions = this.invokeSuperWithTestableVoidParameter(cn, start, end);
            constructor.localVariables = this.createLocalVariables(cn, start, end);
            constructor.maxStack = 3;
        }
        constructor.maxLocals = 2;
        cn.methods.add(constructor);
    }

    private boolean hasSpecialAnnotation(ClassNode cn) {
        if (cn.visibleAnnotations == null) {
            return false;
        }
        for (AnnotationNode an : cn.visibleAnnotations) {
            if (!an.desc.equals(ENABLE_CONFIGURATION)) continue;
            return true;
        }
        return false;
    }

    private boolean isUninstantiableClass(ClassNode cn) {
        for (MethodNode mn : cn.methods) {
            if (!mn.name.equals("<init>")) continue;
            return false;
        }
        return true;
    }

    private boolean isInterfaceOrAtom(ClassNode cn) {
        return (cn.access & 0x200) != 0 || cn.superName == null || VOID_TYPE.equals(cn.name);
    }

    private boolean isJunitTestClass(ClassNode cn) {
        for (MethodNode mn : cn.methods) {
            if (mn.visibleAnnotations == null) continue;
            for (AnnotationNode an : mn.visibleAnnotations) {
                if (!CollectionUtil.contains((Object[])JUNIT_TEST_ANNOTATIONS, (Object)an.desc)) continue;
                return true;
            }
        }
        return false;
    }

    private InsnList invokeSuperWithoutParameter(LabelNode start, LabelNode end) {
        InsnList il = new InsnList();
        il.add(start);
        il.add(new VarInsnNode(25, 0));
        il.add(new MethodInsnNode(183, "java/lang/Object", "<init>", VOID_METHOD, false));
        il.add(new InsnNode(177));
        il.add(end);
        return il;
    }

    private InsnList invokeSuperWithTestableVoidParameter(ClassNode cn, LabelNode start, LabelNode end) {
        InsnList il = new InsnList();
        il.add(start);
        il.add(new VarInsnNode(25, 0));
        if (CollectionUtil.contains((Object[])UNREACHABLE_CLASSES, (Object)cn.superName)) {
            il.add(new MethodInsnNode(183, cn.superName, "<init>", VOID_METHOD, false));
        } else {
            il.add(new VarInsnNode(25, 1));
            il.add(new MethodInsnNode(183, cn.superName, "<init>", METHOD_START + ClassUtil.toByteCodeClassName(VOID_TYPE) + VOID_METHOD_END, false));
        }
        il.add(new InsnNode(177));
        il.add(end);
        return il;
    }

    private List<LocalVariableNode> createLocalVariables(ClassNode cn, LabelNode start, LabelNode end) {
        return com.alibaba.testable.agent.util.CollectionUtil.listOf(new LocalVariableNode("this", ClassUtil.toByteCodeClassName(cn.name), null, start, end, 0), new LocalVariableNode(IGNORE, ClassUtil.toByteCodeClassName(VOID_TYPE), null, start, end, 1));
    }
}

