/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.agent.handler;

import agent.org.objectweb.asm.Label;
import agent.org.objectweb.asm.Type;
import agent.org.objectweb.asm.tree.AbstractInsnNode;
import agent.org.objectweb.asm.tree.AnnotationNode;
import agent.org.objectweb.asm.tree.ClassNode;
import agent.org.objectweb.asm.tree.FieldInsnNode;
import agent.org.objectweb.asm.tree.FieldNode;
import agent.org.objectweb.asm.tree.FrameNode;
import agent.org.objectweb.asm.tree.IincInsnNode;
import agent.org.objectweb.asm.tree.InsnList;
import agent.org.objectweb.asm.tree.InsnNode;
import agent.org.objectweb.asm.tree.JumpInsnNode;
import agent.org.objectweb.asm.tree.LabelNode;
import agent.org.objectweb.asm.tree.LdcInsnNode;
import agent.org.objectweb.asm.tree.LocalVariableNode;
import agent.org.objectweb.asm.tree.MethodInsnNode;
import agent.org.objectweb.asm.tree.MethodNode;
import agent.org.objectweb.asm.tree.TypeInsnNode;
import agent.org.objectweb.asm.tree.VarInsnNode;
import com.alibaba.testable.agent.handler.BaseClassWithContextHandler;
import com.alibaba.testable.agent.tool.ImmutablePair;
import com.alibaba.testable.agent.util.AnnotationUtil;
import com.alibaba.testable.agent.util.BytecodeUtil;
import com.alibaba.testable.agent.util.ClassUtil;
import com.alibaba.testable.agent.util.GlobalConfig;
import com.alibaba.testable.agent.util.MethodUtil;
import com.alibaba.testable.core.model.MockScope;
import com.alibaba.testable.core.util.LogUtil;
import com.alibaba.testable.core.util.MockAssociationUtil;
import java.util.List;

public class MockClassHandler
extends BaseClassWithContextHandler {
    private static final String CLASS_INVOKE_RECORD_UTIL = "com/alibaba/testable/core/util/InvokeRecordUtil";
    private static final String CLASS_MOCK_ASSOCIATION_UTIL = "com/alibaba/testable/core/util/MockAssociationUtil";
    private static final String METHOD_INVOKE_ORIGIN = "invokeOrigin";
    private static final String SIGNATURE_INVOKE_ORIGIN = "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String METHOD_RECORD_MOCK_INVOKE = "recordMockInvoke";
    private static final String SIGNATURE_RECORDER_METHOD_INVOKE = "([Ljava/lang/Object;Z)V";
    private static final String METHOD_IS_ASSOCIATED = "isAssociated";
    private static final String SIGNATURE_IS_ASSOCIATED = "()Z";
    private static final String SELF_REF = "__self";
    private static final String TESTABLE_REF = "__testable";
    private final String mockClassName;

    public MockClassHandler(String className) {
        this.mockClassName = className;
    }

    @Override
    protected void transform(ClassNode cn) {
        LogUtil.diagnose((String)"Found mock class %s", (Object[])new Object[]{cn.name});
        if (!"java/lang/Object".equals(cn.superName)) {
            MockAssociationUtil.recordSubMockContainer((String)ClassUtil.toDotSeparatedName(cn.superName), (String)ClassUtil.toDotSeparatedName(cn.name));
        }
        this.injectRefFieldAndGetInstanceMethod(cn);
        int mockMethodCount = 0;
        for (MethodNode mn : cn.methods) {
            if (!this.isMockMethod(mn)) continue;
            ++mockMethodCount;
            mn.access = BytecodeUtil.toPublicAccess(mn.access);
            this.unfoldTargetClass(mn);
            this.injectInvokeRecorder(mn);
            this.injectAssociationChecker(mn);
            this.handleTestableUtil(mn);
        }
        LogUtil.diagnose((String)"  Found %d mock methods", (Object[])new Object[]{mockMethodCount});
    }

    private void injectRefFieldAndGetInstanceMethod(ClassNode cn) {
        String byteCodeMockClassName = ClassUtil.toByteCodeClassName(this.mockClassName);
        MethodNode getInstanceMethod = new MethodNode(9, "testableIns", "()" + byteCodeMockClassName, null, null);
        InsnList il = new InsnList();
        il.add(new FieldInsnNode(178, this.mockClassName, TESTABLE_REF, byteCodeMockClassName));
        LabelNode label = new LabelNode();
        il.add(new JumpInsnNode(199, label));
        il.add(new TypeInsnNode(187, this.mockClassName));
        il.add(new InsnNode(89));
        il.add(new MethodInsnNode(183, this.mockClassName, "<init>", "()V", false));
        il.add(new FieldInsnNode(179, this.mockClassName, TESTABLE_REF, byteCodeMockClassName));
        il.add(label);
        il.add(new FrameNode(3, 0, null, 0, null));
        il.add(new FieldInsnNode(178, this.mockClassName, TESTABLE_REF, byteCodeMockClassName));
        il.add(new InsnNode(176));
        getInstanceMethod.instructions = il;
        getInstanceMethod.maxStack = 2;
        getInstanceMethod.maxLocals = 0;
        cn.methods.add(getInstanceMethod);
        cn.fields.add(new FieldNode(10, TESTABLE_REF, byteCodeMockClassName, null, null));
    }

    private void unfoldTargetClass(MethodNode mn) {
        String targetClassName = null;
        for (AnnotationNode an : mn.visibleAnnotations) {
            if (!ClassUtil.toByteCodeClassName("com.alibaba.testable.core.annotation.MockMethod").equals(an.desc)) continue;
            Type type = AnnotationUtil.getAnnotationParameter(an, "targetClass", null, Type.class);
            if (type != null) {
                targetClassName = ClassUtil.toByteCodeClassName(type.getClassName());
            }
            AnnotationUtil.removeAnnotationParameter(an, "targetClass");
        }
        if (targetClassName != null) {
            ImmutablePair<LabelNode, LabelNode> labels = this.getStartAndEndLabel(mn);
            mn.desc = MethodUtil.addParameterAtBegin(mn.desc, targetClassName);
            int parameterOffset = MethodUtil.isStatic(mn) ? 0 : Math.min(mn.localVariables.size(), 1);
            mn.localVariables.add(parameterOffset, new LocalVariableNode(SELF_REF, targetClassName, null, (LabelNode)labels.left, (LabelNode)labels.right, parameterOffset));
            for (int i = parameterOffset + 1; i < mn.localVariables.size(); ++i) {
                ++mn.localVariables.get((int)i).index;
            }
            for (AbstractInsnNode in : mn.instructions) {
                if (in instanceof IincInsnNode) {
                    ++((IincInsnNode)in).var;
                    continue;
                }
                if (in instanceof VarInsnNode && ((VarInsnNode)in).var >= parameterOffset) {
                    ++((VarInsnNode)in).var;
                    continue;
                }
                if (!(in instanceof FrameNode) || ((FrameNode)in).type != 0) continue;
                int pos = ((FrameNode)in).local.size() == 0 ? 0 : parameterOffset;
                ((FrameNode)in).local.add(pos, ClassUtil.toSlashSeparateJavaStyleName(targetClassName));
            }
            ++mn.maxLocals;
        }
    }

    private ImmutablePair<LabelNode, LabelNode> getStartAndEndLabel(MethodNode mn) {
        if (MethodUtil.isStatic(mn) || mn.localVariables.isEmpty()) {
            AbstractInsnNode n;
            LabelNode startLabel = null;
            LabelNode endLabel = null;
            for (n = mn.instructions.getFirst(); n != null; n = n.getNext()) {
                if (!(n instanceof LabelNode)) continue;
                startLabel = (LabelNode)n;
                break;
            }
            if (MethodUtil.extractParameters(mn.desc).isEmpty()) {
                endLabel = new LabelNode(new Label());
                mn.instructions.add(endLabel);
            } else {
                for (n = mn.instructions.getLast(); n != null; n = n.getPrevious()) {
                    if (!(n instanceof LabelNode)) continue;
                    endLabel = (LabelNode)n;
                    break;
                }
            }
            return ImmutablePair.of(startLabel, endLabel);
        }
        LocalVariableNode thisRef = mn.localVariables.get(0);
        return ImmutablePair.of(thisRef.start, thisRef.end);
    }

    private void injectAssociationChecker(MethodNode mn) {
        if (this.isGlobalScope(mn)) {
            return;
        }
        LabelNode firstLine = new LabelNode(new Label());
        InsnList il = new InsnList();
        il.add(new MethodInsnNode(184, CLASS_MOCK_ASSOCIATION_UTIL, METHOD_IS_ASSOCIATED, SIGNATURE_IS_ASSOCIATED, false));
        il.add(new JumpInsnNode(154, firstLine));
        il.add(this.invokeOriginalMethod(mn));
        il.add(firstLine);
        il.add(new FrameNode(3, 0, null, 0, null));
        mn.maxStack = Math.max(6, mn.maxStack);
        mn.instructions.insertBefore(mn.instructions.getFirst(), il);
    }

    private InsnList invokeOriginalMethod(MethodNode mn) {
        InsnList il = new InsnList();
        ImmutablePair<Type, String> target = this.getTargetClassAndMethodName(mn);
        il.add(new LdcInsnNode(target.left));
        il.add(new LdcInsnNode(target.right));
        il.add(this.duplicateParameters(mn));
        il.add(new MethodInsnNode(184, CLASS_MOCK_ASSOCIATION_UTIL, METHOD_INVOKE_ORIGIN, SIGNATURE_INVOKE_ORIGIN, false));
        String returnType = MethodUtil.getReturnType(mn.desc);
        if ("V".equals(returnType)) {
            il.add(new InsnNode(87));
            il.add(new InsnNode(177));
        } else if (returnType.charAt(0) == '[' || returnType.charAt(0) == 'L') {
            il.add(new TypeInsnNode(192, ClassUtil.toSlashSeparateJavaStyleName(returnType)));
            il.add(new InsnNode(176));
        } else {
            String wrapperClass = ClassUtil.toWrapperClass(returnType.getBytes()[0]);
            il.add(new TypeInsnNode(192, wrapperClass));
            ImmutablePair<String, String> convertMethod = ClassUtil.getWrapperTypeConvertMethod(returnType.getBytes()[0]);
            il.add(new MethodInsnNode(182, wrapperClass, (String)convertMethod.left, (String)convertMethod.right, false));
            il.add(new InsnNode(ClassUtil.getReturnOpsCode(returnType)));
        }
        return il;
    }

    private ImmutablePair<Type, String> getTargetClassAndMethodName(MethodNode mn) {
        String methodName = mn.name;
        for (AnnotationNode an : mn.visibleAnnotations) {
            if (this.isMockMethodAnnotation(an)) {
                String name = AnnotationUtil.getAnnotationParameter(an, "targetMethod", null, String.class);
                if (name == null) continue;
                methodName = name;
                continue;
            }
            if (!this.isMockConstructorAnnotation(an)) continue;
            methodName = "<init>";
        }
        Type className = methodName.equals("<init>") ? Type.getType(MethodUtil.getReturnType(mn.desc)) : Type.getType(MethodUtil.getFirstParameter(mn.desc));
        return ImmutablePair.of(className, methodName);
    }

    private boolean isGlobalScope(MethodNode mn) {
        for (AnnotationNode an : mn.visibleAnnotations) {
            MockScope scope;
            if (!this.isMockMethodAnnotation(an) && !this.isMockConstructorAnnotation(an) || !(scope = AnnotationUtil.getAnnotationParameter(an, "scope", GlobalConfig.defaultMockScope, MockScope.class)).equals((Object)MockScope.GLOBAL)) continue;
            return true;
        }
        return false;
    }

    private boolean isMockMethod(MethodNode mn) {
        if (mn.visibleAnnotations == null) {
            return false;
        }
        for (AnnotationNode an : mn.visibleAnnotations) {
            if (this.isMockMethodAnnotation(an)) {
                if (LogUtil.isVerboseEnabled()) {
                    LogUtil.verbose((String)"   Mock method \"%s\" as \"%s\"", (Object[])new Object[]{mn.name, MethodUtil.toJavaMethodDesc(this.getTargetMethodOwner(mn, an), this.getTargetMethodName(mn, an), this.getTargetMethodDesc(mn, an))});
                }
                return true;
            }
            if (!this.isMockConstructorAnnotation(an)) continue;
            if (LogUtil.isVerboseEnabled()) {
                LogUtil.verbose((String)"   Mock constructor \"%s\" as \"%s\"", (Object[])new Object[]{mn.name, MethodUtil.toJavaMethodDesc(ClassUtil.toJavaStyleClassName(MethodUtil.getReturnType(mn.desc)), mn.desc)});
            }
            return true;
        }
        return false;
    }

    private String getTargetMethodOwner(MethodNode mn, AnnotationNode mockMethodAnnotation) {
        Type type = AnnotationUtil.getAnnotationParameter(mockMethodAnnotation, "targetClass", null, Type.class);
        return type == null ? MethodUtil.getFirstParameter(mn.desc) : type.getClassName();
    }

    private String getTargetMethodName(MethodNode mn, AnnotationNode mockMethodAnnotation) {
        String name = AnnotationUtil.getAnnotationParameter(mockMethodAnnotation, "targetMethod", null, String.class);
        return name == null ? mn.name : name;
    }

    private String getTargetMethodDesc(MethodNode mn, AnnotationNode mockMethodAnnotation) {
        Type type = AnnotationUtil.getAnnotationParameter(mockMethodAnnotation, "targetClass", null, Type.class);
        return type == null ? MethodUtil.removeFirstParameter(mn.desc) : mn.desc;
    }

    private boolean isMockConstructorAnnotation(AnnotationNode an) {
        return ClassUtil.toByteCodeClassName("com.alibaba.testable.core.annotation.MockConstructor").equals(an.desc);
    }

    private boolean isMockMethodAnnotation(AnnotationNode an) {
        return ClassUtil.toByteCodeClassName("com.alibaba.testable.core.annotation.MockMethod").equals(an.desc);
    }

    private void injectInvokeRecorder(MethodNode mn) {
        InsnList il = new InsnList();
        il.add(this.duplicateParameters(mn));
        if (this.isMockForConstructor(mn)) {
            il.add(new InsnNode(4));
        } else {
            il.add(new InsnNode(3));
        }
        il.add(new MethodInsnNode(184, CLASS_INVOKE_RECORD_UTIL, METHOD_RECORD_MOCK_INVOKE, SIGNATURE_RECORDER_METHOD_INVOKE, false));
        mn.instructions.insertBefore(mn.instructions.getFirst(), il);
        mn.maxStack += 2 + MethodUtil.getParameterTypes(mn.desc).size() * 3;
    }

    private InsnList duplicateParameters(MethodNode mn) {
        InsnList il = new InsnList();
        List<Byte> types = MethodUtil.getParameterTypes(mn.desc);
        int size = types.size();
        il.add(BytecodeUtil.getIntInsn(size));
        il.add(new TypeInsnNode(189, "java/lang/Object"));
        int parameterOffset = MethodUtil.isStatic(mn) ? 0 : 1;
        for (int i = 0; i < size; ++i) {
            il.add(new InsnNode(89));
            il.add(BytecodeUtil.getIntInsn(i));
            ImmutablePair<Integer, Integer> code = BytecodeUtil.getLoadParameterByteCode(types.get(i));
            il.add(new VarInsnNode((Integer)code.left, parameterOffset));
            parameterOffset += ((Integer)code.right).intValue();
            MethodInsnNode typeConvertMethodNode = ClassUtil.getPrimaryTypeConvertMethod(types.get(i));
            if (typeConvertMethodNode != null) {
                il.add(typeConvertMethodNode);
            }
            il.add(new InsnNode(83));
        }
        return il;
    }

    private boolean isMockForConstructor(MethodNode mn) {
        for (AnnotationNode an : mn.visibleAnnotations) {
            String method;
            String annotationName = ClassUtil.toJavaStyleClassName(an.desc);
            if ("com.alibaba.testable.core.annotation.MockConstructor".equals(annotationName)) {
                return true;
            }
            if (!"com.alibaba.testable.core.annotation.MockMethod".equals(annotationName) || !"<init>".equals(method = AnnotationUtil.getAnnotationParameter(an, "targetMethod", null, String.class))) continue;
            return true;
        }
        return false;
    }
}

