/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.client.rocketmq;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ConsumerBatchMessage<T> {
    private final List<T> data;
    private CountDownLatch latch;
    private boolean hasFailure = false;

    public ConsumerBatchMessage(List<T> data) {
        this.data = data;
        this.latch = new CountDownLatch(1);
    }

    public boolean waitFinish(long timeout) throws InterruptedException {
        return this.latch.await(timeout, TimeUnit.MILLISECONDS);
    }

    public boolean isSuccess() {
        return !this.hasFailure;
    }

    public List<T> getData() {
        return this.data;
    }

    public void ack() {
        this.latch.countDown();
    }

    public void fail() {
        this.hasFailure = true;
        long count = this.latch.getCount();
        int i = 0;
        while ((long)i < count) {
            this.latch.countDown();
            ++i;
        }
    }
}

