/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nls.client.protocol.asr;

import com.alibaba.fastjson.JSON;
import com.alibaba.nls.client.protocol.asr.SpeechTranscriber;
import com.alibaba.nls.client.protocol.asr.SpeechTranscriberResponse;
import com.alibaba.nls.client.transport.ConnectionListener;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpeechTranscriberListener
implements ConnectionListener {
    Logger logger = LoggerFactory.getLogger(SpeechTranscriberListener.class);
    private SpeechTranscriber transcriber;

    public void setSpeechTranscriber(SpeechTranscriber transcriber) {
        this.transcriber = transcriber;
    }

    public SpeechTranscriber getSpeechTranscriber() {
        return this.transcriber;
    }

    public void onTranscriberStart(SpeechTranscriberResponse response) {
    }

    public void onSentenceBegin(SpeechTranscriberResponse response) {
    }

    public void onSentenceEnd(SpeechTranscriberResponse response) {
    }

    public void onTranscriptionResultChange(SpeechTranscriberResponse response) {
    }

    public void onTranscriptionComplete(SpeechTranscriberResponse response) {
    }

    public void onFail(int status, String reason) {
        this.logger.error("fail status:{}, reasone:{}", (Object)status, (Object)reason);
    }

    public void onOpen() {
        this.logger.debug("connection is ok");
    }

    public void onClose(int closeCode, String reason) {
        if (this.transcriber != null) {
            this.transcriber.markClosed();
        }
        this.logger.info("connection is closed due to {},code:{}", (Object)reason, (Object)closeCode);
    }

    public void onError(Throwable throwable) {
        this.logger.error(throwable.getMessage(), throwable);
    }

    public void onMessage(String message) {
        if (message == null || message.trim().length() == 0) {
            return;
        }
        this.logger.debug("on message:{}", (Object)message);
        SpeechTranscriberResponse response = (SpeechTranscriberResponse)((Object)JSON.parseObject((String)message, SpeechTranscriberResponse.class));
        if (this.isTranscriptionStarted(response)) {
            this.onTranscriberStart(response);
            this.transcriber.markTranscriberReady();
        } else if (this.isSentenceBegin(response)) {
            this.onSentenceBegin(response);
        } else if (this.isSentenceEnd(response)) {
            this.onSentenceEnd(response);
        } else if (this.isTranscriptionResultChanged(response)) {
            this.onTranscriptionResultChange(response);
        } else if (this.isTranscriptionCompleted(response)) {
            this.onTranscriptionComplete(response);
            this.transcriber.markTranscriberComplete();
        } else if (this.isTaskFailed(response)) {
            this.onFail(response.getStatus(), response.getStatusText());
            this.transcriber.markFail();
        } else {
            this.logger.error("can not process this message: {}", (Object)message);
        }
    }

    public void onMessage(ByteBuffer message) {
    }

    private boolean isTranscriptionStarted(SpeechTranscriberResponse response) {
        String name = response.getName();
        return name.equals("TranscriptionStarted");
    }

    private boolean isSentenceBegin(SpeechTranscriberResponse response) {
        String name = response.getName();
        return name.equals("SentenceBegin");
    }

    private boolean isSentenceEnd(SpeechTranscriberResponse response) {
        String name = response.getName();
        return name.equals("SentenceEnd");
    }

    private boolean isTranscriptionResultChanged(SpeechTranscriberResponse response) {
        String name = response.getName();
        return name.equals("TranscriptionResultChanged");
    }

    private boolean isTranscriptionCompleted(SpeechTranscriberResponse response) {
        String name = response.getName();
        return name.equals("TranscriptionCompleted");
    }

    private boolean isTaskFailed(SpeechTranscriberResponse response) {
        String name = response.getName();
        return name.equals("TaskFailed");
    }
}

