/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nls.client.transport.netty4;

import com.alibaba.nls.client.transport.Connection;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyConnection
implements Connection {
    static Logger logger = LoggerFactory.getLogger(NettyConnection.class);
    Channel channel;

    public NettyConnection(Channel channel) {
        this.channel = channel;
    }

    @Override
    public String getId() {
        if (this.channel != null) {
            return this.channel.id().toString();
        }
        return null;
    }

    @Override
    public void close() {
        this.channel.close();
    }

    @Override
    public void sendText(String payload) {
        if (this.channel != null && this.channel.isActive()) {
            logger.debug("thread:{},send:{}", (Object)Thread.currentThread().getId(), (Object)payload);
            TextWebSocketFrame frame = new TextWebSocketFrame(payload);
            this.channel.writeAndFlush((Object)frame);
        }
    }

    @Override
    public void sendBinary(byte[] payload) {
        if (this.channel != null && this.channel.isActive()) {
            BinaryWebSocketFrame frame = new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])payload));
            this.channel.writeAndFlush((Object)frame);
        }
    }
}

