/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.util;

import com.alibaba.nacos.spring.util.ConfigParse;
import com.alibaba.nacos.spring.util.parse.DefaultJsonConfigParse;
import com.alibaba.nacos.spring.util.parse.DefaultPropertiesConfigParse;
import com.alibaba.nacos.spring.util.parse.DefaultXmlConfigParse;
import com.alibaba.nacos.spring.util.parse.DefaultYamlConfigParse;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;

public final class ConfigParseUtils {
    private static final String LINK_CHAR = "#@#";
    private static Map<String, ConfigParse> DEFAULT_CONFIG_PARSE_MAP = new HashMap<String, ConfigParse>(8);
    private static Map<String, Map<String, ConfigParse>> CUSTOMER_CONFIG_PARSE_MAP = new HashMap<String, Map<String, ConfigParse>>(8);

    public static Map<String, Object> toProperties(String context, String type) {
        if (context == null) {
            return new LinkedHashMap<String, Object>();
        }
        if (DEFAULT_CONFIG_PARSE_MAP.containsKey(type = type.toLowerCase())) {
            ConfigParse configParse = DEFAULT_CONFIG_PARSE_MAP.get(type);
            return configParse.parse(context);
        }
        throw new UnsupportedOperationException("Parsing is not yet supported for this type profile : " + type);
    }

    public static Map<String, Object> toProperties(String dataId, String group, String context, String type) {
        if (context == null) {
            return new LinkedHashMap<String, Object>();
        }
        type = type.toLowerCase();
        String configParseKey = dataId + LINK_CHAR + group;
        if (CUSTOMER_CONFIG_PARSE_MAP.isEmpty() || LINK_CHAR.equals(configParseKey)) {
            return ConfigParseUtils.toProperties(context, type);
        }
        if (CUSTOMER_CONFIG_PARSE_MAP.get(type) == null || CUSTOMER_CONFIG_PARSE_MAP.get(type).isEmpty()) {
            return ConfigParseUtils.toProperties(context, type);
        }
        if (CUSTOMER_CONFIG_PARSE_MAP.get(type).get(configParseKey) == null) {
            return ConfigParseUtils.toProperties(context, type);
        }
        if (CUSTOMER_CONFIG_PARSE_MAP.containsKey(type)) {
            ConfigParse configParse = CUSTOMER_CONFIG_PARSE_MAP.get(type).get(configParseKey);
            if (configParse == null) {
                throw new NoSuchElementException("This config can't find ConfigParse to parse");
            }
            return configParse.parse(context);
        }
        throw new UnsupportedOperationException("Parsing is not yet supported for this type profile : " + type);
    }

    static {
        DefaultJsonConfigParse jsonConfigParse = new DefaultJsonConfigParse();
        DefaultPropertiesConfigParse propertiesConfigParse = new DefaultPropertiesConfigParse();
        DefaultYamlConfigParse yamlConfigParse = new DefaultYamlConfigParse();
        DefaultXmlConfigParse xmlConfigParse = new DefaultXmlConfigParse();
        DEFAULT_CONFIG_PARSE_MAP.put(jsonConfigParse.processType().toLowerCase(), jsonConfigParse);
        DEFAULT_CONFIG_PARSE_MAP.put(propertiesConfigParse.processType().toLowerCase(), propertiesConfigParse);
        DEFAULT_CONFIG_PARSE_MAP.put(yamlConfigParse.processType().toLowerCase(), yamlConfigParse);
        DEFAULT_CONFIG_PARSE_MAP.put(xmlConfigParse.processType().toLowerCase(), xmlConfigParse);
        ServiceLoader<ConfigParse> configParses = ServiceLoader.load(ConfigParse.class);
        StringBuilder sb = new StringBuilder();
        for (ConfigParse configParse : configParses) {
            String type = configParse.processType().toLowerCase();
            if (!CUSTOMER_CONFIG_PARSE_MAP.containsKey(type)) {
                CUSTOMER_CONFIG_PARSE_MAP.put(type, new HashMap(1));
            }
            sb.setLength(0);
            sb.append(configParse.dataId()).append(LINK_CHAR).append(configParse.group());
            if (LINK_CHAR.equals(sb.toString())) {
                DEFAULT_CONFIG_PARSE_MAP.put(type, configParse);
                continue;
            }
            CUSTOMER_CONFIG_PARSE_MAP.get(type).put(sb.toString(), configParse);
        }
        DEFAULT_CONFIG_PARSE_MAP = Collections.unmodifiableMap(DEFAULT_CONFIG_PARSE_MAP);
        CUSTOMER_CONFIG_PARSE_MAP = Collections.unmodifiableMap(CUSTOMER_CONFIG_PARSE_MAP);
    }
}

