/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.context.event;

import com.alibaba.nacos.spring.util.NacosUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public abstract class AnnotationListenerMethodProcessor<A extends Annotation>
implements ApplicationListener<ContextRefreshedEvent> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Class<A> annotationType = NacosUtils.resolveGenericType(this.getClass());

    static boolean isListenerMethod(Method method) {
        int modifiers = method.getModifiers();
        Class<?> returnType = method.getReturnType();
        return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isNative(modifiers) && !Modifier.isAbstract(modifiers) && Void.TYPE.equals(returnType);
    }

    public final void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        this.processBeans(applicationContext);
    }

    private void processBeans(ApplicationContext applicationContext) {
        Map beansMap = applicationContext.getBeansOfType(Object.class, false, false);
        this.processBeans(beansMap, applicationContext);
    }

    private void processBeans(Map<String, Object> beansMap, ApplicationContext applicationContext) {
        for (Map.Entry<String, Object> entry : beansMap.entrySet()) {
            String beanName = entry.getKey();
            Object bean = entry.getValue();
            if (bean == null) continue;
            Class beanClass = AopUtils.getTargetClass((Object)bean);
            this.processBean(beanName, bean, beanClass, applicationContext);
        }
    }

    private void processBean(final String beanName, final Object bean, final Class<?> beanClass, final ApplicationContext applicationContext) {
        ReflectionUtils.doWithMethods(beanClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Annotation annotation = AnnotationUtils.getAnnotation((Method)method, (Class)AnnotationListenerMethodProcessor.this.annotationType);
                if (annotation != null && AnnotationListenerMethodProcessor.this.isCandidateMethod(bean, beanClass, annotation, method, applicationContext)) {
                    AnnotationListenerMethodProcessor.this.processListenerMethod(beanName, bean, beanClass, annotation, method, applicationContext);
                }
            }
        }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                return AnnotationListenerMethodProcessor.isListenerMethod(method);
            }
        });
    }

    protected abstract void processListenerMethod(String var1, Object var2, Class<?> var3, A var4, Method var5, ApplicationContext var6);

    protected boolean isCandidateMethod(Object bean, Class<?> beanClass, A annotation, Method method, ApplicationContext applicationContext) {
        return true;
    }
}

