/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.beans.factory.annotation;

import com.alibaba.nacos.api.annotation.NacosInjected;
import com.alibaba.nacos.spring.beans.factory.annotation.AbstractAnnotationBeanPostProcessor;
import com.alibaba.nacos.spring.beans.factory.annotation.AbstractNacosServiceBeanBuilder;
import com.alibaba.spring.util.BeanUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.annotation.AnnotationAttributes;

public class AnnotationNacosInjectedBeanPostProcessor
extends AbstractAnnotationBeanPostProcessor
implements InitializingBean {
    public static final String BEAN_NAME = "annotationNacosInjectedBeanPostProcessor";
    private Map<Class<?>, AbstractNacosServiceBeanBuilder> nacosServiceBeanBuilderMap;

    public AnnotationNacosInjectedBeanPostProcessor() {
        super(NacosInjected.class);
    }

    public final void afterPropertiesSet() {
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        this.initNacosServiceBeanBuilderMap(beanFactory);
    }

    /*
     * WARNING - void declaration
     */
    private void initNacosServiceBeanBuilderMap(ConfigurableListableBeanFactory beanFactory) {
        void var7_9;
        Class<AbstractNacosServiceBeanBuilder> builderClass = AbstractNacosServiceBeanBuilder.class;
        String[] beanNames = BeanUtils.getBeanNames((ConfigurableListableBeanFactory)beanFactory, builderClass);
        if (beanNames.length == 0) {
            throw new NoSuchBeanDefinitionException(builderClass, String.format("Please check the BeanDefinition of %s in Spring BeanFactory", builderClass));
        }
        ArrayList<Object> serviceBeanBuilders = new ArrayList<Object>(beanNames.length);
        String[] stringArray = beanNames;
        int n = stringArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            String beanName = stringArray[var7_9];
            serviceBeanBuilders.add(beanFactory.getBean(beanName, builderClass));
            ++var7_9;
        }
        if (serviceBeanBuilders.isEmpty()) {
            throw new NoSuchBeanDefinitionException(builderClass, String.format("Please check the BeanDefinition of %s in Spring BeanFactory", builderClass));
        }
        HashMap builderMap = new HashMap(serviceBeanBuilders.size());
        for (AbstractNacosServiceBeanBuilder abstractNacosServiceBeanBuilder : serviceBeanBuilders) {
            Class<?> type = abstractNacosServiceBeanBuilder.getType();
            builderMap.put(type, abstractNacosServiceBeanBuilder);
        }
        this.nacosServiceBeanBuilderMap = Collections.unmodifiableMap(builderMap);
    }

    @Override
    protected Object doGetInjectedBean(AnnotationAttributes attributes, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) throws Exception {
        AbstractNacosServiceBeanBuilder serviceBeanBuilder = this.nacosServiceBeanBuilderMap.get(injectedType);
        Map<String, Object> nacosProperties = this.getNacosProperties(attributes);
        return serviceBeanBuilder.build(nacosProperties);
    }

    @Override
    protected String buildInjectedObjectCacheKey(AnnotationAttributes attributes, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) {
        StringBuilder keyBuilder = new StringBuilder(injectedType.getSimpleName());
        AbstractNacosServiceBeanBuilder serviceBeanBuilder = this.nacosServiceBeanBuilderMap.get(injectedType);
        if (serviceBeanBuilder == null) {
            throw new UnsupportedOperationException(String.format("Only support to inject types[%s] instance , however actual injected type [%s] in member[%s]", this.nacosServiceBeanBuilderMap.keySet(), injectedType, injectedElement.getMember()));
        }
        Map<String, Object> nacosProperties = this.getNacosProperties(attributes);
        Properties properties = serviceBeanBuilder.resolveProperties(nacosProperties);
        keyBuilder.append(properties);
        return keyBuilder.toString();
    }

    private Map<String, Object> getNacosProperties(AnnotationAttributes attributes) {
        return (Map)attributes.get((Object)"properties");
    }
}

