/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.beans.factory.annotation;

import com.alibaba.nacos.api.annotation.NacosProperties;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.spring.factory.NacosServiceFactory;
import com.alibaba.nacos.spring.util.GlobalNacosPropertiesSource;
import com.alibaba.nacos.spring.util.NacosBeanUtils;
import com.alibaba.nacos.spring.util.NacosUtils;
import com.alibaba.spring.util.ClassUtils;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

public abstract class AbstractNacosServiceBeanBuilder<S>
implements BeanFactoryAware,
EnvironmentAware {
    private final Class<?> type = ClassUtils.resolveGenericType(this.getClass());
    private final GlobalNacosPropertiesSource source;
    private BeanFactory beanFactory;
    private Environment environment;

    protected AbstractNacosServiceBeanBuilder(GlobalNacosPropertiesSource source) {
        this.source = source;
    }

    public S build(NacosProperties nacosProperties) {
        return this.build(AnnotationUtils.getAnnotationAttributes((Annotation)nacosProperties));
    }

    public S build(Map<String, Object> nacosPropertiesAttributes) {
        NacosServiceFactory nacosServiceFactory = NacosBeanUtils.getNacosServiceFactoryBean(this.beanFactory);
        Properties properties = this.resolveProperties(nacosPropertiesAttributes);
        if (properties.isEmpty()) {
            throw new BeanCreationException(String.format("The @%s attributes must be configured", NacosProperties.class.getSimpleName()));
        }
        try {
            return this.createService(nacosServiceFactory, properties);
        }
        catch (NacosException e) {
            throw new BeanCreationException(e.getErrMsg(), (Throwable)e);
        }
    }

    protected abstract S createService(NacosServiceFactory var1, Properties var2) throws NacosException;

    public final Properties resolveProperties(NacosProperties nacosProperties) {
        Properties globalNacosProperties = this.resolveGlobalNacosProperties();
        return NacosUtils.resolveProperties(nacosProperties, (PropertyResolver)this.environment, globalNacosProperties);
    }

    public final Properties resolveProperties(Map<String, Object> nacosPropertiesAttributes) {
        Properties globalNacosProperties = this.resolveGlobalNacosProperties();
        return NacosUtils.resolveProperties(nacosPropertiesAttributes, (PropertyResolver)this.environment, globalNacosProperties);
    }

    private Properties resolveGlobalNacosProperties() {
        return this.source.getMergedGlobalProperties(this.beanFactory);
    }

    final Class<?> getType() {
        return this.type;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

