/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.util;

import com.alibaba.nacos.spring.beans.factory.annotation.AnnotationNacosInjectedBeanPostProcessor;
import com.alibaba.nacos.spring.beans.factory.annotation.ConfigServiceBeanBuilder;
import com.alibaba.nacos.spring.beans.factory.annotation.NamingMaintainServiceBeanBuilder;
import com.alibaba.nacos.spring.beans.factory.annotation.NamingServiceBeanBuilder;
import com.alibaba.nacos.spring.context.annotation.config.NacosConfigListenerMethodProcessor;
import com.alibaba.nacos.spring.context.annotation.config.NacosValueAnnotationBeanPostProcessor;
import com.alibaba.nacos.spring.context.constants.NacosConstants;
import com.alibaba.nacos.spring.context.event.LoggingNacosConfigMetadataEventListener;
import com.alibaba.nacos.spring.context.properties.config.NacosConfigurationPropertiesBindingPostProcessor;
import com.alibaba.nacos.spring.core.env.AnnotationNacosPropertySourceBuilder;
import com.alibaba.nacos.spring.core.env.NacosPropertySourcePostProcessor;
import com.alibaba.nacos.spring.core.env.XmlNacosPropertySourceBuilder;
import com.alibaba.nacos.spring.factory.ApplicationContextHolder;
import com.alibaba.nacos.spring.factory.CacheableEventPublishingNacosServiceFactory;
import com.alibaba.nacos.spring.factory.NacosServiceFactory;
import com.alibaba.nacos.spring.util.NacosUtils;
import com.alibaba.spring.util.BeanUtils;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

public abstract class NacosBeanUtils {
    public static final String PLACEHOLDER_CONFIGURER_BEAN_NAME = "propertySourcesPlaceholderConfigurer";
    public static final String GLOBAL_NACOS_PROPERTIES_BEAN_NAME = "globalNacosProperties";
    public static final String CONFIG_GLOBAL_NACOS_PROPERTIES_BEAN_NAME = "globalNacosProperties$config";
    public static final String DISCOVERY_GLOBAL_NACOS_PROPERTIES_BEAN_NAME = "globalNacosProperties$discovery";
    public static final String MAINTAIN_GLOBAL_NACOS_PROPERTIES_BEAN_NAME = "globalNacosProperties$maintain";
    public static final String NACOS_CONFIG_LISTENER_EXECUTOR_BEAN_NAME = "nacosConfigListenerExecutor";

    public static void registerSingleton(BeanDefinitionRegistry registry, String beanName, Object singletonObject) {
        SingletonBeanRegistry beanRegistry = null;
        if (registry instanceof SingletonBeanRegistry) {
            beanRegistry = (SingletonBeanRegistry)registry;
        } else if (registry instanceof AbstractApplicationContext) {
            beanRegistry = ((AbstractApplicationContext)registry).getBeanFactory();
        }
        if (beanRegistry != null) {
            beanRegistry.registerSingleton(beanName, singletonObject);
        }
    }

    public static void registerInfrastructureBean(BeanDefinitionRegistry registry, String beanName, Class<?> beanClass, Object ... constructorArgs) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(beanClass);
        for (Object constructorArg : constructorArgs) {
            beanDefinitionBuilder.addConstructorArgValue(constructorArg);
        }
        beanDefinitionBuilder.setRole(2);
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
    }

    public static void registerInfrastructureBeanIfAbsent(BeanDefinitionRegistry registry, String beanName, Class<?> beanClass, Object ... constructorArgs) {
        if (!NacosBeanUtils.isBeanDefinitionPresent(registry, beanName, beanClass) && !registry.containsBeanDefinition(beanName)) {
            NacosBeanUtils.registerInfrastructureBean(registry, beanName, beanClass, constructorArgs);
        }
    }

    public static BeanFactory resolveBeanFactory(BeanDefinitionRegistry registry) {
        if (registry instanceof BeanFactory) {
            return (BeanFactory)registry;
        }
        if (registry instanceof AbstractApplicationContext) {
            return ((AbstractApplicationContext)registry).getBeanFactory();
        }
        return null;
    }

    public static boolean isBeanDefinitionPresent(BeanDefinitionRegistry registry, String beanName, Class<?> targetBeanClass) {
        Object[] beanNames = BeanUtils.getBeanNames((ListableBeanFactory)((ListableBeanFactory)registry), targetBeanClass);
        return ArrayUtils.contains((Object[])beanNames, (Object)beanName);
    }

    public static void registerPropertySourcesPlaceholderConfigurer(BeanDefinitionRegistry registry) {
        NacosBeanUtils.registerInfrastructureBeanIfAbsent(registry, PLACEHOLDER_CONFIGURER_BEAN_NAME, PropertySourcesPlaceholderConfigurer.class, new Object[0]);
    }

    public static void registerGlobalNacosProperties(AnnotationAttributes attributes, BeanDefinitionRegistry registry, PropertyResolver propertyResolver, String beanName) {
        if (attributes == null) {
            return;
        }
        AnnotationAttributes globalPropertiesAttributes = attributes.getAnnotation("globalProperties");
        NacosBeanUtils.registerGlobalNacosProperties(globalPropertiesAttributes, registry, propertyResolver, beanName);
    }

    public static void registerGlobalNacosProperties(Map<?, ?> globalPropertiesAttributes, BeanDefinitionRegistry registry, PropertyResolver propertyResolver, String beanName) {
        Properties globalProperties = NacosUtils.resolveProperties(globalPropertiesAttributes, propertyResolver);
        NacosBeanUtils.registerSingleton(registry, beanName, globalProperties);
    }

    public static void registerNacosApplicationContextHolder(BeanDefinitionRegistry registry) {
        NacosBeanUtils.registerInfrastructureBeanIfAbsent(registry, "nacosApplicationContextHolder", ApplicationContextHolder.class, new Object[0]);
    }

    public static void registerNacosConfigPropertiesBindingPostProcessor(BeanDefinitionRegistry registry) {
        NacosBeanUtils.registerInfrastructureBeanIfAbsent(registry, "nacosConfigurationPropertiesBindingPostProcessor", NacosConfigurationPropertiesBindingPostProcessor.class, new Object[0]);
    }

    public static void registerNacosConfigListenerMethodProcessor(BeanDefinitionRegistry registry) {
        NacosBeanUtils.registerInfrastructureBeanIfAbsent(registry, "nacosConfigListenerMethodProcessor", NacosConfigListenerMethodProcessor.class, new Object[0]);
    }

    public static void registerNacosPropertySourcePostProcessor(BeanDefinitionRegistry registry) {
        NacosBeanUtils.registerInfrastructureBeanIfAbsent(registry, "nacosPropertySourcePostProcessor", NacosPropertySourcePostProcessor.class, new Object[0]);
    }

    public static void registerAnnotationNacosPropertySourceBuilder(BeanDefinitionRegistry registry) {
        NacosBeanUtils.registerInfrastructureBeanIfAbsent(registry, "annotationNacosPropertySourceBuilder", AnnotationNacosPropertySourceBuilder.class, new Object[0]);
    }

    public static void registerXmlNacosPropertySourceBuilder(BeanDefinitionRegistry registry) {
        NacosBeanUtils.registerInfrastructureBeanIfAbsent(registry, "xmlNacosPropertySourceBuilder", XmlNacosPropertySourceBuilder.class, new Object[0]);
    }

    public static void registerNacosConfigListenerExecutor(BeanDefinitionRegistry registry, Environment environment) {
        String beanName = NACOS_CONFIG_LISTENER_EXECUTOR_BEAN_NAME;
        if (registry instanceof BeanFactory && ((BeanFactory)registry).containsBean(NACOS_CONFIG_LISTENER_EXECUTOR_BEAN_NAME)) {
            return;
        }
        ExecutorService nacosConfigListenerExecutor = NacosBeanUtils.buildNacosConfigListenerExecutor(environment);
        NacosBeanUtils.registerSingleton(registry, NACOS_CONFIG_LISTENER_EXECUTOR_BEAN_NAME, nacosConfigListenerExecutor);
    }

    private static ExecutorService buildNacosConfigListenerExecutor(Environment environment) {
        int parallelism = NacosBeanUtils.getParallelism(environment);
        return Executors.newFixedThreadPool(parallelism, new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("NacosConfigListener-ThreadPool-" + this.threadNumber.getAndIncrement());
                return thread;
            }
        });
    }

    private static int getParallelism(Environment environment) {
        int parallelism = (Integer)environment.getProperty("nacos.config.listener.parallelism", Integer.TYPE, (Object)NacosConstants.DEFAULT_NACOS_CONFIG_LISTENER_PARALLELISM);
        return parallelism < 1 ? NacosConstants.DEFAULT_NACOS_CONFIG_LISTENER_PARALLELISM : parallelism;
    }

    public static void registerNacosValueAnnotationBeanPostProcessor(BeanDefinitionRegistry registry) {
        NacosBeanUtils.registerInfrastructureBeanIfAbsent(registry, "nacosValueAnnotationBeanPostProcessor", NacosValueAnnotationBeanPostProcessor.class, new Object[0]);
    }

    public static void registerNacosCommonBeans(BeanDefinitionRegistry registry) {
        NacosBeanUtils.registerNacosApplicationContextHolder(registry);
        NacosBeanUtils.registerAnnotationNacosInjectedBeanPostProcessor(registry);
    }

    public static void registerNacosConfigBeans(BeanDefinitionRegistry registry, Environment environment) {
        NacosBeanUtils.registerPropertySourcesPlaceholderConfigurer(registry);
        NacosBeanUtils.registerNacosConfigPropertiesBindingPostProcessor(registry);
        NacosBeanUtils.registerNacosConfigListenerMethodProcessor(registry);
        NacosBeanUtils.registerNacosPropertySourcePostProcessor(registry);
        NacosBeanUtils.registerAnnotationNacosPropertySourceBuilder(registry);
        NacosBeanUtils.registerNacosConfigListenerExecutor(registry, environment);
        NacosBeanUtils.registerNacosValueAnnotationBeanPostProcessor(registry);
        NacosBeanUtils.registerConfigServiceBeanBuilder(registry);
        NacosBeanUtils.registerLoggingNacosConfigMetadataEventListener(registry);
    }

    public static void invokeNacosPropertySourcePostProcessor(BeanFactory beanFactory) {
        NacosPropertySourcePostProcessor postProcessor = (NacosPropertySourcePostProcessor)beanFactory.getBean("nacosPropertySourcePostProcessor", NacosPropertySourcePostProcessor.class);
        postProcessor.postProcessBeanFactory((ConfigurableListableBeanFactory)beanFactory);
    }

    private static void registerLoggingNacosConfigMetadataEventListener(BeanDefinitionRegistry registry) {
        NacosBeanUtils.registerInfrastructureBeanIfAbsent(registry, "loggingNacosConfigMetadataEventListener", LoggingNacosConfigMetadataEventListener.class, new Object[0]);
    }

    public static void registerNacosDiscoveryBeans(BeanDefinitionRegistry registry) {
        NacosBeanUtils.registerNamingServiceBeanBuilder(registry);
        NacosBeanUtils.registerNamingMaintainServiceBeanBuilder(registry);
    }

    private static void registerAnnotationNacosInjectedBeanPostProcessor(BeanDefinitionRegistry registry) {
        NacosBeanUtils.registerInfrastructureBeanIfAbsent(registry, "annotationNacosInjectedBeanPostProcessor", AnnotationNacosInjectedBeanPostProcessor.class, new Object[0]);
    }

    private static void registerConfigServiceBeanBuilder(BeanDefinitionRegistry registry) {
        NacosBeanUtils.registerInfrastructureBeanIfAbsent(registry, "configServiceBeanBuilder", ConfigServiceBeanBuilder.class, new Object[0]);
    }

    private static void registerNamingServiceBeanBuilder(BeanDefinitionRegistry registry) {
        NacosBeanUtils.registerInfrastructureBeanIfAbsent(registry, "namingServiceBeanBuilder", NamingServiceBeanBuilder.class, new Object[0]);
    }

    private static void registerNamingMaintainServiceBeanBuilder(BeanDefinitionRegistry registry) {
        NacosBeanUtils.registerInfrastructureBeanIfAbsent(registry, "namingMaintainServiceBeanBuilder", NamingMaintainServiceBeanBuilder.class, new Object[0]);
    }

    public static Properties getGlobalPropertiesBean(BeanFactory beanFactory) throws NoSuchBeanDefinitionException {
        return (Properties)beanFactory.getBean(GLOBAL_NACOS_PROPERTIES_BEAN_NAME, Properties.class);
    }

    public static NacosServiceFactory getNacosServiceFactoryBean(BeanFactory beanFactory) throws NoSuchBeanDefinitionException {
        if (null == beanFactory) {
            return NacosBeanUtils.getNacosServiceFactoryBean();
        }
        ApplicationContextHolder applicationContextHolder = NacosBeanUtils.getApplicationContextHolder(beanFactory);
        CacheableEventPublishingNacosServiceFactory nacosServiceFactory = CacheableEventPublishingNacosServiceFactory.getSingleton();
        nacosServiceFactory.setApplicationContext((ApplicationContext)applicationContextHolder.getApplicationContext());
        return nacosServiceFactory;
    }

    public static NacosServiceFactory getNacosServiceFactoryBean() throws NoSuchBeanDefinitionException {
        return CacheableEventPublishingNacosServiceFactory.getSingleton();
    }

    public static ApplicationContextHolder getApplicationContextHolder(BeanFactory beanFactory) throws NoSuchBeanDefinitionException {
        return (ApplicationContextHolder)beanFactory.getBean("nacosApplicationContextHolder", ApplicationContextHolder.class);
    }

    public static ExecutorService getNacosConfigListenerExecutorIfPresent(BeanFactory beanFactory) {
        if (!beanFactory.containsBean(NACOS_CONFIG_LISTENER_EXECUTOR_BEAN_NAME)) {
            return null;
        }
        return (ExecutorService)beanFactory.getBean(NACOS_CONFIG_LISTENER_EXECUTOR_BEAN_NAME, ExecutorService.class);
    }

    public static ConfigServiceBeanBuilder getConfigServiceBeanBuilder(BeanFactory beanFactory) throws NoSuchBeanDefinitionException {
        return (ConfigServiceBeanBuilder)beanFactory.getBean("configServiceBeanBuilder", ConfigServiceBeanBuilder.class);
    }

    public static NamingServiceBeanBuilder getNamingServiceBeanBuilder(BeanFactory beanFactory) throws NoSuchBeanDefinitionException {
        return (NamingServiceBeanBuilder)beanFactory.getBean("namingServiceBeanBuilder", NamingServiceBeanBuilder.class);
    }

    public static NamingMaintainServiceBeanBuilder getNamingMaintainServiceBeanBuilder(BeanFactory beanFactory) throws NoSuchBeanDefinitionException {
        return (NamingMaintainServiceBeanBuilder)beanFactory.getBean("namingMaintainServiceBeanBuilder", NamingMaintainServiceBeanBuilder.class);
    }
}

