/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.control.tps;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.control.Loggers;
import com.alibaba.nacos.plugin.control.rule.parser.NacosTpsControlRuleParser;
import com.alibaba.nacos.plugin.control.rule.parser.TpsControlRuleParser;
import com.alibaba.nacos.plugin.control.rule.storage.RuleStorageProxy;
import com.alibaba.nacos.plugin.control.tps.barrier.TpsBarrier;
import com.alibaba.nacos.plugin.control.tps.barrier.creator.DefaultNacosTpsBarrierCreator;
import com.alibaba.nacos.plugin.control.tps.barrier.creator.TpsBarrierCreator;
import com.alibaba.nacos.plugin.control.tps.request.TpsCheckRequest;
import com.alibaba.nacos.plugin.control.tps.response.TpsCheckResponse;
import com.alibaba.nacos.plugin.control.tps.rule.TpsControlRule;
import java.util.Map;

public abstract class TpsControlManager {
    private final TpsControlRuleParser tpsControlRuleParser = this.buildTpsControlRuleParser();
    protected final TpsBarrierCreator tpsBarrierCreator = this.buildTpsBarrierCreator();

    protected TpsControlManager() {
    }

    public TpsControlRuleParser getTpsControlRuleParser() {
        return this.tpsControlRuleParser;
    }

    protected TpsControlRuleParser buildTpsControlRuleParser() {
        return new NacosTpsControlRuleParser();
    }

    protected TpsBarrierCreator buildTpsBarrierCreator() {
        return new DefaultNacosTpsBarrierCreator();
    }

    protected void initTpsRule(String pointName) {
        RuleStorageProxy ruleStorageProxy = RuleStorageProxy.getInstance();
        String localRuleContent = ruleStorageProxy.getLocalDiskStorage().getTpsRule(pointName);
        if (StringUtils.isNotBlank((String)localRuleContent)) {
            Loggers.CONTROL.info("Found local disk tps control rule of {},content ={}", (Object)pointName, (Object)localRuleContent);
        } else if (ruleStorageProxy.getExternalStorage() != null && ruleStorageProxy.getExternalStorage().getTpsRule(pointName) != null && StringUtils.isNotBlank((String)(localRuleContent = ruleStorageProxy.getExternalStorage().getTpsRule(pointName)))) {
            Loggers.CONTROL.info("Found external  tps control rule of {},content ={}", (Object)pointName, (Object)localRuleContent);
        }
        if (StringUtils.isNotBlank((String)localRuleContent)) {
            TpsControlRule tpsLimitRule = (TpsControlRule)this.tpsControlRuleParser.parseRule(localRuleContent);
            this.applyTpsRule(pointName, tpsLimitRule);
        } else {
            Loggers.CONTROL.info("No tps control rule of {} found  ", (Object)pointName, (Object)localRuleContent);
        }
    }

    public abstract void registerTpsPoint(String var1);

    public abstract Map<String, TpsBarrier> getPoints();

    public abstract Map<String, TpsControlRule> getRules();

    public abstract void applyTpsRule(String var1, TpsControlRule var2);

    public abstract TpsCheckResponse check(TpsCheckRequest var1);

    public abstract String getName();
}

