/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.capacity;

import com.alibaba.nacos.common.util.SystemUtils;
import com.alibaba.nacos.config.server.model.capacity.Capacity;
import com.alibaba.nacos.config.server.model.capacity.GroupCapacity;
import com.alibaba.nacos.config.server.service.DataSourceService;
import com.alibaba.nacos.config.server.service.DynamicDataSource;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Service;

@Service
public class GroupCapacityPersistService {
    static final String CLUSTER = "";
    private static final GroupCapacityRowMapper GROUP_CAPACITY_ROW_MAPPER = new GroupCapacityRowMapper();
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private DynamicDataSource dynamicDataSource;
    private DataSourceService dataSourceService;

    @PostConstruct
    public void init() {
        this.dataSourceService = this.dynamicDataSource.getDataSource();
        this.jdbcTemplate = this.dataSourceService.getJdbcTemplate();
    }

    public GroupCapacity getGroupCapacity(String groupId) {
        String sql = "SELECT id, quota, `usage`, `max_size`, max_aggr_count, max_aggr_size, group_id FROM group_capacity WHERE group_id=?";
        List list = this.jdbcTemplate.query(sql, new Object[]{groupId}, (RowMapper)GROUP_CAPACITY_ROW_MAPPER);
        if (list.isEmpty()) {
            return null;
        }
        return (GroupCapacity)list.get(0);
    }

    public Capacity getClusterCapacity() {
        return this.getGroupCapacity(CLUSTER);
    }

    public boolean insertGroupCapacity(GroupCapacity capacity) {
        String sql = CLUSTER.equals(capacity.getGroup()) ? "insert into group_capacity (group_id, quota, `usage`, `max_size`, max_aggr_count, max_aggr_size, gmt_create, gmt_modified) select ?, ?, count(*), ?, ?, ?, ?, ? from config_info;" : "insert into group_capacity (group_id, quota, `usage`, `max_size`, max_aggr_count, max_aggr_size, gmt_create, gmt_modified) select ?, ?, count(*), ?, ?, ?, ?, ? from config_info where group_id=? and tenant_id = '';";
        return this.insertGroupCapacity(sql, capacity);
    }

    public int getClusterUsage() {
        Capacity clusterCapacity = this.getClusterCapacity();
        if (clusterCapacity != null) {
            return clusterCapacity.getUsage();
        }
        String sql = "SELECT count(*) FROM config_info";
        Integer result = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoCount error");
        }
        return result;
    }

    private boolean insertGroupCapacity(final String sql, final GroupCapacity capacity) {
        try {
            GeneratedKeyHolder generatedKeyHolder = new GeneratedKeyHolder();
            PreparedStatementCreator preparedStatementCreator = new PreparedStatementCreator(){

                @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION_EXCEPTION_EDGE", "SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="findbugs does not trust jdbctemplate, sql is constant in practice")
                public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                    PreparedStatement ps = connection.prepareStatement(sql, 1);
                    String group = capacity.getGroup();
                    ps.setString(1, group);
                    ps.setInt(2, capacity.getQuota());
                    ps.setInt(3, capacity.getMaxSize());
                    ps.setInt(4, capacity.getMaxAggrCount());
                    ps.setInt(5, capacity.getMaxAggrSize());
                    ps.setTimestamp(6, capacity.getGmtCreate());
                    ps.setTimestamp(7, capacity.getGmtModified());
                    if (!GroupCapacityPersistService.CLUSTER.equals(group)) {
                        ps.setString(8, group);
                    }
                    return ps;
                }
            };
            this.jdbcTemplate.update(preparedStatementCreator, (KeyHolder)generatedKeyHolder);
            return generatedKeyHolder.getKey() != null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean incrementUsageWithDefaultQuotaLimit(GroupCapacity groupCapacity) {
        String sql = "UPDATE group_capacity SET `usage` = `usage` + 1, gmt_modified = ? WHERE group_id = ? AND `usage` < ? AND quota = 0";
        try {
            int affectRow = this.jdbcTemplate.update(sql, new Object[]{groupCapacity.getGmtModified(), groupCapacity.getGroup(), groupCapacity.getQuota()});
            return affectRow == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean incrementUsageWithQuotaLimit(GroupCapacity groupCapacity) {
        String sql = "UPDATE group_capacity SET `usage` = `usage` + 1, gmt_modified = ? WHERE group_id = ? AND `usage` < quota AND quota != 0";
        try {
            return this.jdbcTemplate.update(sql, new Object[]{groupCapacity.getGmtModified(), groupCapacity.getGroup()}) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean incrementUsage(GroupCapacity groupCapacity) {
        String sql = "UPDATE group_capacity SET `usage` = `usage` + 1, gmt_modified = ? WHERE group_id = ?";
        try {
            int affectRow = this.jdbcTemplate.update(sql, new Object[]{groupCapacity.getGmtModified(), groupCapacity.getGroup()});
            return affectRow == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean decrementUsage(GroupCapacity groupCapacity) {
        String sql = "UPDATE group_capacity SET `usage` = `usage` - 1, gmt_modified = ? WHERE group_id = ? AND `usage` > 0";
        try {
            return this.jdbcTemplate.update(sql, new Object[]{groupCapacity.getGmtModified(), groupCapacity.getGroup()}) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean updateGroupCapacity(String group, Integer quota, Integer maxSize, Integer maxAggrCount, Integer maxAggrSize) {
        ArrayList argList = Lists.newArrayList();
        StringBuilder sql = new StringBuilder("update group_capacity set");
        if (quota != null) {
            sql.append(" quota = ?,");
            argList.add(quota);
        }
        if (maxSize != null) {
            sql.append(" max_size = ?,");
            argList.add(maxSize);
        }
        if (maxAggrCount != null) {
            sql.append(" max_aggr_count = ?,");
            argList.add(maxAggrCount);
        }
        if (maxAggrSize != null) {
            sql.append(" max_aggr_size = ?,");
            argList.add(maxAggrSize);
        }
        sql.append(" gmt_modified = ?");
        argList.add(TimeUtils.getCurrentTime());
        sql.append(" where group_id = ?");
        argList.add(group);
        try {
            return this.jdbcTemplate.update(sql.toString(), argList.toArray()) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean updateQuota(String group, Integer quota) {
        return this.updateGroupCapacity(group, quota, null, null, null);
    }

    public boolean updateMaxSize(String group, Integer maxSize) {
        return this.updateGroupCapacity(group, null, maxSize, null, null);
    }

    public boolean correctUsage(String group, Timestamp gmtModified) {
        if (CLUSTER.equals(group)) {
            String sql = "UPDATE group_capacity SET `usage` = (SELECT count(*) FROM config_info), gmt_modified = ? WHERE group_id = ?";
            try {
                return this.jdbcTemplate.update(sql, new Object[]{gmtModified, group}) == 1;
            }
            catch (CannotGetJdbcConnectionException e) {
                LogUtil.fatalLog.error("[db-error]", (Throwable)e);
                throw e;
            }
        }
        String sql = "UPDATE group_capacity SET `usage` = (SELECT count(*) FROM config_info WHERE group_id=? AND tenant_id = ''), gmt_modified = ? WHERE group_id = ?";
        try {
            return this.jdbcTemplate.update(sql, new Object[]{group, gmtModified, group}) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public List<GroupCapacity> getCapacityList4CorrectUsage(long lastId, int pageSize) {
        String sql = "SELECT id, group_id FROM group_capacity WHERE id>? LIMIT ?";
        if (SystemUtils.STANDALONE_MODE && !PropertyUtil.isStandaloneUseMysql()) {
            sql = "SELECT id, group_id FROM group_capacity WHERE id>? OFFSET 0 ROWS FETCH NEXT ? ROWS ONLY";
        }
        try {
            return this.jdbcTemplate.query(sql, new Object[]{lastId, pageSize}, (RowMapper)new RowMapper<GroupCapacity>(){

                public GroupCapacity mapRow(ResultSet rs, int rowNum) throws SQLException {
                    GroupCapacity groupCapacity = new GroupCapacity();
                    groupCapacity.setId(rs.getLong("id"));
                    groupCapacity.setGroup(rs.getString("group_id"));
                    return groupCapacity;
                }
            });
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean deleteGroupCapacity(final String group) {
        try {
            PreparedStatementCreator preparedStatementCreator = new PreparedStatementCreator(){

                @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION_EXCEPTION_EDGE", "SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="findbugs does not trust jdbctemplate, sql is constant in practice")
                public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                    PreparedStatement ps = connection.prepareStatement("DELETE FROM group_capacity WHERE group_id = ?;");
                    ps.setString(1, group);
                    return ps;
                }
            };
            return this.jdbcTemplate.update(preparedStatementCreator) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    private static final class GroupCapacityRowMapper
    implements RowMapper<GroupCapacity> {
        private GroupCapacityRowMapper() {
        }

        public GroupCapacity mapRow(ResultSet rs, int rowNum) throws SQLException {
            GroupCapacity groupCapacity = new GroupCapacity();
            groupCapacity.setId(rs.getLong("id"));
            groupCapacity.setQuota(rs.getInt("quota"));
            groupCapacity.setUsage(rs.getInt("usage"));
            groupCapacity.setMaxSize(rs.getInt("max_size"));
            groupCapacity.setMaxAggrCount(rs.getInt("max_aggr_count"));
            groupCapacity.setMaxAggrSize(rs.getInt("max_aggr_size"));
            groupCapacity.setGroup(rs.getString("group_id"));
            return groupCapacity;
        }
    }
}

