/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.model;

import com.alibaba.nacos.common.model.RestResult;

public class RestResultUtils {
    public static <T> RestResult<T> success() {
        return RestResult.builder().withCode(200).build();
    }

    public static <T> RestResult<T> success(T data) {
        return RestResult.builder().withCode(200).withData(data).build();
    }

    public static <T> RestResult<T> success(int code, T data) {
        return RestResult.builder().withCode(code).withData(data).build();
    }

    public static <T> RestResult<T> failed() {
        return RestResult.builder().withCode(500).build();
    }

    public static <T> RestResult<T> failed(String errMsg) {
        return RestResult.builder().withCode(500).withMsg(errMsg).build();
    }

    public static <T> RestResult<T> failed(int code, T data) {
        return RestResult.builder().withCode(code).withData(data).build();
    }

    public static <T> RestResult<T> failed(int code, T data, String errMsg) {
        return RestResult.builder().withCode(code).withData(data).withMsg(errMsg).build();
    }

    public static <T> RestResult<T> failedWithMsg(int code, String errMsg) {
        return RestResult.builder().withCode(code).withMsg(errMsg).build();
    }
}

