/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.ai;

import com.alibaba.nacos.api.ai.AiService;
import com.alibaba.nacos.api.ai.listener.AbstractNacosMcpServerListener;
import com.alibaba.nacos.api.ai.listener.NacosMcpServerEvent;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointSpec;
import com.alibaba.nacos.api.ai.model.mcp.McpServerBasicInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.client.ai.cache.NacosMcpServerCacheHolder;
import com.alibaba.nacos.client.ai.event.McpServerChangeNotifier;
import com.alibaba.nacos.client.ai.event.McpServerChangedEvent;
import com.alibaba.nacos.client.ai.event.McpServerListenerInvoker;
import com.alibaba.nacos.client.ai.remote.AiGrpcClient;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.utils.ClientBasicParamUtil;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Properties;
import org.slf4j.Logger;

public class NacosAiService
implements AiService {
    private static final Logger LOGGER = LogUtils.logger(NacosAiService.class);
    private final String namespaceId;
    private final AiGrpcClient grpcClient;
    private final NacosMcpServerCacheHolder cacheHolder;
    private final McpServerChangeNotifier mcpServerNotifier;

    public NacosAiService(Properties properties) throws NacosException {
        NacosClientProperties clientProperties = NacosClientProperties.PROTOTYPE.derive(properties);
        LOGGER.info(ClientBasicParamUtil.getInputParameters((Properties)clientProperties.asProperties()));
        this.namespaceId = this.initNamespace(clientProperties);
        this.grpcClient = new AiGrpcClient(this.namespaceId, clientProperties);
        this.cacheHolder = new NacosMcpServerCacheHolder(this.grpcClient, clientProperties);
        this.mcpServerNotifier = new McpServerChangeNotifier();
        this.start();
    }

    private String initNamespace(NacosClientProperties properties) {
        String tempNamespace = properties.getProperty("namespace");
        if (StringUtils.isBlank(tempNamespace)) {
            return "public";
        }
        return tempNamespace;
    }

    private void start() throws NacosException {
        this.grpcClient.start(this.cacheHolder);
        NotifyCenter.registerToPublisher(McpServerChangedEvent.class, 16384);
        NotifyCenter.registerSubscriber(this.mcpServerNotifier);
    }

    @Override
    public McpServerDetailInfo getMcpServer(String mcpName, String version) throws NacosException {
        if (StringUtils.isBlank(mcpName)) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "Required parameter `mcpName` not present");
        }
        return this.grpcClient.queryMcpServer(mcpName, version);
    }

    @Override
    public String releaseMcpServer(McpServerBasicInfo serverSpecification, McpToolSpecification toolSpecification, McpEndpointSpec endpointSpecification) throws NacosException {
        if (null == serverSpecification) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "Required parameter `serverSpecification` not present");
        }
        if (StringUtils.isBlank(serverSpecification.getName())) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "Required parameter `serverSpecification.name` not present");
        }
        if (null == serverSpecification.getVersionDetail() || StringUtils.isBlank(serverSpecification.getVersionDetail().getVersion())) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "Required parameter `serverSpecification.versionDetail.version` not present");
        }
        return this.grpcClient.releaseMcpServer(serverSpecification, toolSpecification, endpointSpecification);
    }

    @Override
    public void registerMcpServerEndpoint(String mcpName, String address, int port, String version) throws NacosException {
        if (StringUtils.isBlank(mcpName)) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "parameters `mcpName` can't be empty or null");
        }
        Instance instance = new Instance();
        instance.setIp(address);
        instance.setPort(port);
        instance.validate();
        this.grpcClient.registerMcpServerEndpoint(mcpName, address, port, version);
    }

    @Override
    public void deregisterMcpServerEndpoint(String mcpName, String address, int port) throws NacosException {
        if (StringUtils.isBlank(mcpName)) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "parameters `mcpName` can't be empty or null");
        }
        Instance instance = new Instance();
        instance.setIp(address);
        instance.setPort(port);
        instance.validate();
        this.grpcClient.deregisterMcpServerEndpoint(mcpName, address, port);
    }

    @Override
    public McpServerDetailInfo subscribeMcpServer(String mcpName, String version, AbstractNacosMcpServerListener mcpServerListener) throws NacosException {
        if (StringUtils.isBlank(mcpName)) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "parameters `mcpName` can't be empty or null");
        }
        if (null == mcpServerListener) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "parameters `mcpServerListener` can't be empty or null");
        }
        McpServerListenerInvoker listenerInvoker = new McpServerListenerInvoker(mcpServerListener);
        this.mcpServerNotifier.registerListener(mcpName, version, listenerInvoker);
        McpServerDetailInfo result = this.grpcClient.subscribeMcpServer(mcpName, version);
        if (!listenerInvoker.isInvoked()) {
            listenerInvoker.invoke(new NacosMcpServerEvent(result));
        }
        return result;
    }

    @Override
    public void unsubscribeMcpServer(String mcpName, String version, AbstractNacosMcpServerListener mcpServerListener) throws NacosException {
        if (StringUtils.isBlank(mcpName)) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "parameters `mcpName` can't be empty or null");
        }
        if (null == mcpServerListener) {
            return;
        }
        McpServerListenerInvoker listenerInvoker = new McpServerListenerInvoker(mcpServerListener);
        this.mcpServerNotifier.deregisterListener(mcpName, version, listenerInvoker);
        if (!this.mcpServerNotifier.isSubscribed(mcpName)) {
            this.grpcClient.unsubscribeMcpServer(mcpName, version);
        }
    }

    @Override
    public void shutdown() throws NacosException {
        this.grpcClient.shutdown();
        this.cacheHolder.shutdown();
    }
}

