package com.alibaba.nacos.shaded.org.checkerframework.checker.i18nformatter.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import com.alibaba.nacos.shaded.org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import com.alibaba.nacos.shaded.org.checkerframework.framework.qual.InvisibleQualifier;
import com.alibaba.nacos.shaded.org.checkerframework.framework.qual.SubtypeOf;
import com.alibaba.nacos.shaded.org.checkerframework.framework.qual.TargetLocations;
import com.alibaba.nacos.shaded.org.checkerframework.framework.qual.TypeUseLocation;

/**
 * The top qualifier.
 *
 * <p>A type annotation indicating that the run-time value might or might not be a valid i18n format
 * string.
 *
 * @checker_framework.manual #i18n-formatter-checker Internationalization Format String Checker
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@TargetLocations({TypeUseLocation.EXPLICIT_LOWER_BOUND, TypeUseLocation.EXPLICIT_UPPER_BOUND})
@InvisibleQualifier
@SubtypeOf({})
@DefaultQualifierInHierarchy
public @interface I18nUnknownFormat {}
