package com.alibaba.nacos.shaded.org.checkerframework.checker.index.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import com.alibaba.nacos.shaded.org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import com.alibaba.nacos.shaded.org.checkerframework.framework.qual.SubtypeOf;

/**
 * The top qualifier for the LessThan type hierarchy. It indicates that no other expression is known
 * to be larger than the annotated one.
 *
 * @checker_framework.manual #index-inequalities Index Chceker Inequalities
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
@SubtypeOf({})
@DefaultQualifierInHierarchy
public @interface LessThanUnknown {}
