/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.config;

import com.alibaba.nacos.api.utils.StringUtils;

public enum ConfigType {
    PROPERTIES("properties"),
    XML("xml"),
    JSON("json"),
    TEXT("text"),
    HTML("html"),
    YAML("yaml"),
    UNSET("unset");

    String type;

    private ConfigType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static ConfigType getDefaultType() {
        return TEXT;
    }

    public static Boolean isValidType(String type) {
        if (StringUtils.isBlank(type)) {
            return false;
        }
        for (ConfigType value : ConfigType.values()) {
            if (!value.type.equals(type)) continue;
            return true;
        }
        return false;
    }
}

