/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.net;

import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

@Deprecated
public class HttpClient {
    public static final int READ_TIME_OUT_MILLIS = Integer.getInteger("com.alibaba.nacos.client.naming.rtimeout", 50000);
    public static final int CON_TIME_OUT_MILLIS = Integer.getInteger("com.alibaba.nacos.client.naming.ctimeout", 3000);
    private static final boolean ENABLE_HTTPS = Boolean.getBoolean("tls.enable");

    public static String getPrefix() {
        if (ENABLE_HTTPS) {
            return "https://";
        }
        return "http://";
    }

    public static HttpResult httpGet(String url, List<String> headers, Map<String, String> paramValues, String encoding) {
        return HttpClient.request(url, headers, paramValues, "", encoding, "GET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult request(String url, List<String> headers, Map<String, String> paramValues, String body, String encoding, String method) {
        Object b;
        URLConnection conn = null;
        try {
            String encodedContent = HttpClient.encodingParams(paramValues, encoding);
            url = url + (StringUtils.isEmpty((String)encodedContent) ? "" : "?" + encodedContent);
            conn = (HttpURLConnection)new URL(url).openConnection();
            HttpClient.setHeaders((HttpURLConnection)conn, headers, encoding);
            conn.setConnectTimeout(CON_TIME_OUT_MILLIS);
            conn.setReadTimeout(READ_TIME_OUT_MILLIS);
            ((HttpURLConnection)conn).setRequestMethod(method);
            conn.setDoOutput(true);
            if (StringUtils.isNotBlank((String)body)) {
                b = body.getBytes();
                conn.setRequestProperty("Content-Length", String.valueOf(((byte[])b).length));
                conn.getOutputStream().write((byte[])b, 0, ((byte[])b).length);
                conn.getOutputStream().flush();
                conn.getOutputStream().close();
            }
            conn.connect();
            if (LogUtils.NAMING_LOGGER.isDebugEnabled()) {
                LogUtils.NAMING_LOGGER.debug("Request from server: " + url);
            }
            b = HttpClient.getResult((HttpURLConnection)conn);
        }
        catch (Exception e) {
            HttpResult httpResult;
            try {
                try {
                    if (conn != null) {
                        LogUtils.NAMING_LOGGER.warn("failed to request " + conn.getURL() + " from " + InetAddress.getByName(conn.getURL().getHost()).getHostAddress());
                    }
                }
                catch (Exception ex) {
                    LogUtils.NAMING_LOGGER.error("[NA] failed to request ", (Throwable)ex);
                }
                LogUtils.NAMING_LOGGER.error("[NA] failed to request ", (Throwable)e);
                httpResult = new HttpResult(500, e.toString(), Collections.<String, String>emptyMap());
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(conn);
                throw throwable;
            }
            IoUtils.closeQuietly((HttpURLConnection)conn);
            return httpResult;
        }
        IoUtils.closeQuietly((HttpURLConnection)conn);
        return b;
    }

    private static HttpResult getResult(HttpURLConnection conn) throws IOException {
        int respCode = conn.getResponseCode();
        InputStream inputStream = 200 == respCode || 304 == respCode || 307 == respCode ? conn.getInputStream() : conn.getErrorStream();
        HashMap<String, String> respHeaders = new HashMap<String, String>(conn.getHeaderFields().size());
        for (Map.Entry<String, List<String>> entry : conn.getHeaderFields().entrySet()) {
            respHeaders.put(entry.getKey(), entry.getValue().get(0));
        }
        String encodingGzip = "gzip";
        if (encodingGzip.equals(respHeaders.get("Content-Encoding"))) {
            inputStream = new GZIPInputStream(inputStream);
        }
        HttpResult httpResult = new HttpResult(respCode, IoUtils.toString((InputStream)inputStream, (String)HttpClient.getCharset(conn)), respHeaders);
        if (inputStream instanceof GZIPInputStream) {
            inputStream.close();
        }
        return httpResult;
    }

    private static String getCharset(HttpURLConnection conn) {
        String contentType = conn.getContentType();
        if (StringUtils.isEmpty((String)contentType)) {
            return "UTF-8";
        }
        String[] values = contentType.split(";");
        if (values.length == 0) {
            return "UTF-8";
        }
        String charset = "UTF-8";
        for (String value : values) {
            if (!(value = value.trim()).toLowerCase().startsWith("charset=")) continue;
            charset = value.substring("charset=".length());
        }
        return charset;
    }

    private static void setHeaders(HttpURLConnection conn, List<String> headers, String encoding) {
        if (null != headers) {
            Iterator<String> iter = headers.iterator();
            while (iter.hasNext()) {
                conn.addRequestProperty(iter.next(), iter.next());
            }
        }
        conn.addRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + encoding);
        conn.addRequestProperty("Accept-Charset", encoding);
    }

    private static String encodingParams(Map<String, String> params, String encoding) throws UnsupportedEncodingException {
        if (null == params || params.isEmpty()) {
            return "";
        }
        params.put("encoding", encoding);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (StringUtils.isEmpty((String)entry.getValue())) continue;
            sb.append(entry.getKey()).append("=");
            sb.append(URLEncoder.encode(entry.getValue(), encoding));
            sb.append("&");
        }
        if (sb.length() > 0) {
            sb = sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    static {
        System.setProperty("http.maxRedirects", "5");
    }

    public static class HttpResult {
        public final int code;
        public final String content;
        private final Map<String, String> respHeaders;

        public HttpResult(int code, String content, Map<String, String> respHeaders) {
            this.code = code;
            this.content = content;
            this.respHeaders = respHeaders;
        }

        public String getHeader(String name) {
            return this.respHeaders.get(name);
        }

        public String toString() {
            return "HttpResult{code=" + this.code + ", content='" + this.content + '\'' + ", respHeaders=" + this.respHeaders + '}';
        }
    }
}

