/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.selector.AbstractSelector;
import com.alibaba.nacos.client.naming.beat.BeatInfo;
import com.alibaba.nacos.client.naming.beat.BeatReactor;
import com.alibaba.nacos.client.naming.core.Balancer;
import com.alibaba.nacos.client.naming.core.EventDispatcher;
import com.alibaba.nacos.client.naming.core.HostReactor;
import com.alibaba.nacos.client.naming.net.NamingProxy;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.naming.utils.LogUtils;
import com.alibaba.nacos.client.naming.utils.StringUtils;
import com.alibaba.nacos.client.naming.utils.UtilAndComs;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class NacosNamingService
implements NamingService {
    private String namespace;
    private String endpoint;
    private String serverList;
    private String cacheDir;
    private String logName;
    private HostReactor hostReactor;
    private BeatReactor beatReactor;
    private EventDispatcher eventDispatcher;
    private NamingProxy serverProxy;

    private void init() {
        String logLevel;
        this.namespace = System.getProperty("namespace");
        if (StringUtils.isEmpty(this.namespace)) {
            this.namespace = "public";
        }
        this.logName = System.getProperty("com.alibaba.nacos.naming.log.filename");
        if (StringUtils.isEmpty(this.logName)) {
            this.logName = "naming.log";
        }
        if (StringUtils.isEmpty(logLevel = System.getProperty("com.alibaba.nacos.naming.log.level"))) {
            logLevel = "INFO";
        }
        LogUtils.setLogLevel(logLevel);
        this.cacheDir = System.getProperty("com.alibaba.nacos.naming.cache.dir");
        if (StringUtils.isEmpty(this.cacheDir)) {
            this.cacheDir = System.getProperty("user.home") + "/nacos/naming/" + this.namespace;
        }
    }

    public NacosNamingService(String serverList) {
        this.serverList = serverList;
        this.init();
        this.eventDispatcher = new EventDispatcher();
        this.serverProxy = new NamingProxy(this.namespace, this.endpoint, serverList);
        this.beatReactor = new BeatReactor(this.serverProxy);
        this.hostReactor = new HostReactor(this.eventDispatcher, this.serverProxy, this.cacheDir);
    }

    public NacosNamingService(Properties properties) {
        this.init();
        this.serverList = properties.getProperty("serverAddr");
        if (StringUtils.isNotEmpty(properties.getProperty("namespace"))) {
            this.namespace = properties.getProperty("namespace");
        }
        if (StringUtils.isNotEmpty(properties.getProperty("com.alibaba.nacos.naming.log.filename"))) {
            this.logName = properties.getProperty("com.alibaba.nacos.naming.log.filename");
        }
        if (StringUtils.isNotEmpty(properties.getProperty("endpoint"))) {
            this.endpoint = properties.getProperty("endpoint") + ":" + properties.getProperty("address.server.port", "8080");
        }
        this.cacheDir = System.getProperty("user.home") + "/nacos/naming/" + this.namespace;
        boolean loadCacheAtStart = false;
        if (StringUtils.isNotEmpty(properties.getProperty("namingLoadCacheAtStart"))) {
            loadCacheAtStart = BooleanUtils.toBoolean((String)properties.getProperty("namingLoadCacheAtStart"));
        }
        int clientBeatThreadCount = NumberUtils.toInt((String)properties.getProperty("namingClientBeatThreadCount"), (int)UtilAndComs.DEFAULT_CLIENT_BEAT_THREAD_COUNT);
        int pollingThreadCount = NumberUtils.toInt((String)properties.getProperty("namingPollingThreadCount"), (int)UtilAndComs.DEFAULT_POLLING_THREAD_COUNT);
        this.eventDispatcher = new EventDispatcher();
        this.serverProxy = new NamingProxy(this.namespace, this.endpoint, this.serverList);
        this.beatReactor = new BeatReactor(this.serverProxy, clientBeatThreadCount);
        this.hostReactor = new HostReactor(this.eventDispatcher, this.serverProxy, this.cacheDir, loadCacheAtStart, pollingThreadCount);
    }

    public void registerInstance(String serviceName, String ip, int port) throws NacosException {
        this.registerInstance(serviceName, ip, port, "DEFAULT");
    }

    public void registerInstance(String serviceName, String ip, int port, String clusterName) throws NacosException {
        Instance instance = new Instance();
        instance.setIp(ip);
        instance.setPort(port);
        instance.setWeight(1.0);
        instance.setClusterName(clusterName);
        this.registerInstance(serviceName, instance);
    }

    public void registerInstance(String serviceName, Instance instance) throws NacosException {
        BeatInfo beatInfo = new BeatInfo();
        beatInfo.setServiceName(serviceName);
        beatInfo.setIp(instance.getIp());
        beatInfo.setPort(instance.getPort());
        beatInfo.setCluster(instance.getClusterName());
        beatInfo.setWeight(instance.getWeight());
        beatInfo.setMetadata(instance.getMetadata());
        beatInfo.setScheduled(false);
        this.beatReactor.addBeatInfo(serviceName, beatInfo);
        this.serverProxy.registerService(serviceName, instance);
    }

    public void deregisterInstance(String serviceName, String ip, int port) throws NacosException {
        this.deregisterInstance(serviceName, ip, port, "DEFAULT");
    }

    public void deregisterInstance(String serviceName, String ip, int port, String clusterName) throws NacosException {
        this.beatReactor.removeBeatInfo(serviceName, ip, port);
        this.serverProxy.deregisterService(serviceName, ip, port, clusterName);
    }

    public List<Instance> getAllInstances(String serviceName) throws NacosException {
        return this.getAllInstances(serviceName, new ArrayList<String>());
    }

    public List<Instance> getAllInstances(String serviceName, boolean subscribe) throws NacosException {
        return this.getAllInstances(serviceName, new ArrayList<String>(), subscribe);
    }

    public List<Instance> getAllInstances(String serviceName, List<String> clusters) throws NacosException {
        return this.getAllInstances(serviceName, clusters, true);
    }

    public List<Instance> getAllInstances(String serviceName, List<String> clusters, boolean subscribe) throws NacosException {
        List list;
        ServiceInfo serviceInfo = subscribe ? this.hostReactor.getServiceInfo(serviceName, StringUtils.join(clusters, ",")) : this.hostReactor.getServiceInfoDirectlyFromServer(serviceName, StringUtils.join(clusters, ","));
        if (serviceInfo == null || CollectionUtils.isEmpty(list = serviceInfo.getHosts())) {
            return new ArrayList<Instance>();
        }
        return list;
    }

    public List<Instance> selectInstances(String serviceName, boolean healthy) throws NacosException {
        return this.selectInstances(serviceName, new ArrayList<String>(), healthy);
    }

    public List<Instance> selectInstances(String serviceName, boolean healthy, boolean subscribe) throws NacosException {
        return this.selectInstances(serviceName, new ArrayList<String>(), healthy, subscribe);
    }

    public List<Instance> selectInstances(String serviceName, List<String> clusters, boolean healthy) throws NacosException {
        return this.selectInstances(serviceName, clusters, healthy, true);
    }

    public List<Instance> selectInstances(String serviceName, List<String> clusters, boolean healthy, boolean subscribe) throws NacosException {
        ServiceInfo serviceInfo = subscribe ? this.hostReactor.getServiceInfo(serviceName, StringUtils.join(clusters, ",")) : this.hostReactor.getServiceInfoDirectlyFromServer(serviceName, StringUtils.join(clusters, ","));
        return this.selectInstances(serviceInfo, healthy);
    }

    public Instance selectOneHealthyInstance(String serviceName) throws NacosException {
        return this.selectOneHealthyInstance(serviceName, new ArrayList<String>());
    }

    public Instance selectOneHealthyInstance(String serviceName, boolean subscribe) throws NacosException {
        return this.selectOneHealthyInstance(serviceName, new ArrayList<String>(), subscribe);
    }

    public Instance selectOneHealthyInstance(String serviceName, List<String> clusters) throws NacosException {
        return this.selectOneHealthyInstance(serviceName, clusters, true);
    }

    public Instance selectOneHealthyInstance(String serviceName, List<String> clusters, boolean subscribe) throws NacosException {
        if (subscribe) {
            return Balancer.RandomByWeight.selectHost(this.hostReactor.getServiceInfo(serviceName, StringUtils.join(clusters, ",")));
        }
        return Balancer.RandomByWeight.selectHost(this.hostReactor.getServiceInfoDirectlyFromServer(serviceName, StringUtils.join(clusters, ",")));
    }

    public void subscribe(String service, EventListener listener) {
        this.eventDispatcher.addListener(this.hostReactor.getServiceInfo(service, ""), "", listener);
    }

    public void subscribe(String service, List<String> clusters, EventListener listener) {
        this.eventDispatcher.addListener(this.hostReactor.getServiceInfo(service, StringUtils.join(clusters, ",")), StringUtils.join(clusters, ","), listener);
    }

    public void unsubscribe(String service, EventListener listener) {
        this.eventDispatcher.removeListener(service, "", listener);
    }

    public void unsubscribe(String service, List<String> clusters, EventListener listener) {
        this.eventDispatcher.removeListener(service, StringUtils.join(clusters, ","), listener);
    }

    public ListView<String> getServicesOfServer(int pageNo, int pageSize) throws NacosException {
        return this.serverProxy.getServiceList(pageNo, pageSize);
    }

    public ListView<String> getServicesOfServer(int pageNo, int pageSize, AbstractSelector selector) throws NacosException {
        return this.serverProxy.getServiceList(pageNo, pageSize, selector);
    }

    public List<ServiceInfo> getSubscribeServices() {
        return this.eventDispatcher.getSubscribeServices();
    }

    public String getServerStatus() {
        return this.serverProxy.serverHealthy() ? "UP" : "DOWN";
    }

    private List<Instance> selectInstances(ServiceInfo serviceInfo, boolean healthy) {
        List list;
        if (serviceInfo == null || CollectionUtils.isEmpty(list = serviceInfo.getHosts())) {
            return new ArrayList<Instance>();
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Instance instance = (Instance)iterator.next();
            if (healthy == instance.isHealthy() && instance.isEnabled() && !(instance.getWeight() <= 0.0)) continue;
            iterator.remove();
        }
        return list;
    }

    public BeatReactor getBeatReactor() {
        return this.beatReactor;
    }
}

