/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.aliyun.auth.injector;

import com.alibaba.nacos.client.aliyun.auth.ExtensionRamContext;
import com.alibaba.nacos.client.aliyun.auth.injector.AbstractExtensionResourceInjector;
import com.alibaba.nacos.client.auth.ram.utils.SpasAdapter;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.auth.api.RequestResource;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class ConfigExtensionResourceInjector
extends AbstractExtensionResourceInjector {
    private static final Logger LOGGER = LogUtils.logger(ConfigExtensionResourceInjector.class);
    private static final String ACCESS_KEY_HEADER = "Spas-AccessKey";
    private static final String DEFAULT_RESOURCE = "";

    @Override
    protected String getAccessKeyHeaderKey() {
        return ACCESS_KEY_HEADER;
    }

    @Override
    protected Map<String, String> calculateSignature(RequestResource resource, String actualSecretKey, ExtensionRamContext ramContext) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String resourceString = this.getResource(resource.getNamespace(), resource.getGroup());
            Map signHeaders = SpasAdapter.getSignHeaders((String)resourceString, (String)actualSecretKey);
            result.putAll(signHeaders);
        }
        catch (Exception e) {
            LOGGER.warn("Calculate auth signature for config failed.", (Throwable)e);
        }
        return result;
    }

    private String getResource(String tenant, String group) {
        if (StringUtils.isNotBlank((String)tenant) && StringUtils.isNotBlank((String)group)) {
            return tenant + "+" + group;
        }
        if (StringUtils.isNotBlank((String)group)) {
            return group;
        }
        if (StringUtils.isNotBlank((String)tenant)) {
            return tenant;
        }
        return DEFAULT_RESOURCE;
    }
}

