/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.aliyun;

import com.alibaba.nacos.client.aliyun.AliyunConst;
import com.alibaba.nacos.client.aliyun.AsyncProcessor;
import com.alibaba.nacos.client.aliyun.KmsEncryptor;
import com.alibaba.nacos.client.aliyun.provider.AccessKeyCredentialsProvider;
import com.alibaba.nacos.client.aliyun.provider.CredentialsUriKmsCredentialsProvider;
import com.alibaba.nacos.client.aliyun.provider.EcsRamRoleKmsCredentialsProvider;
import com.alibaba.nacos.client.aliyun.provider.KmsCredentialsProvider;
import com.alibaba.nacos.client.aliyun.provider.OidcRoleArnKmsCredentialsProvider;
import com.alibaba.nacos.client.aliyun.provider.RamRoleArnKmsCredentialsProvider;
import com.alibaba.nacos.client.aliyun.provider.StsTokenKmsCredentialsProvider;
import com.alibaba.nacos.common.utils.StringUtils;
import com.aliyun.credentials.Client;
import com.aliyun.kms20160120.models.DecryptRequest;
import com.aliyun.kms20160120.models.DescribeKeyRequest;
import com.aliyun.kms20160120.models.DescribeKeyResponse;
import com.aliyun.kms20160120.models.EncryptRequest;
import com.aliyun.kms20160120.models.GenerateDataKeyRequest;
import com.aliyun.kms20160120.models.GenerateDataKeyResponseBody;
import com.aliyun.kms20160120.models.SetDeletionProtectionRequest;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import com.aliyuncs.exceptions.ClientException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RamKmsEncryptor
extends KmsEncryptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RamKmsEncryptor.class);
    private com.aliyun.kms20160120.Client kmsClient;
    private String keyId;
    private RuntimeOptions runtimeOptions;
    private Exception localInitException;
    private final Set<String> addedKeys = new HashSet<String>();
    private AsyncProcessor asyncProcessor;
    private final Set<KmsCredentialsProvider> credentialsProviders = new HashSet<KmsCredentialsProvider>();

    public RamKmsEncryptor(Properties properties) {
        super(properties);
        this.credentialsProviders.add(new AccessKeyCredentialsProvider());
        this.credentialsProviders.add(new StsTokenKmsCredentialsProvider());
        this.credentialsProviders.add(new RamRoleArnKmsCredentialsProvider());
        this.credentialsProviders.add(new EcsRamRoleKmsCredentialsProvider());
        this.credentialsProviders.add(new OidcRoleArnKmsCredentialsProvider());
        this.credentialsProviders.add(new CredentialsUriKmsCredentialsProvider());
        try {
            this.kmsClient = this.createClient(properties);
        }
        catch (Exception e) {
            this.localInitException = e;
        }
        if (this.localInitException == null) {
            try {
                this.asyncProcessor = new AsyncProcessor();
            }
            catch (Exception e) {
                LOGGER.error("init async processor failed.", (Throwable)e);
            }
        }
    }

    private com.aliyun.kms20160120.Client createClient(Properties properties) throws Exception {
        String kmsCaFilePath;
        String regionId = properties.getProperty("regionId", System.getProperty("regionId", System.getenv("regionId")));
        String kmsRegionId = properties.getProperty("kms_region_id", System.getProperty("kms_region_id", System.getenv("kms_region_id")));
        if (StringUtils.isBlank((CharSequence)regionId)) {
            regionId = kmsRegionId;
        }
        LOGGER.info("using regionId {}.", (Object)regionId);
        if (StringUtils.isBlank((CharSequence)kmsRegionId)) {
            kmsRegionId = regionId;
        }
        LOGGER.info("using kms regionId {}.", (Object)kmsRegionId);
        String kmsEndpoint = properties.getProperty("kmsEndpoint", System.getProperty("kmsEndpoint", System.getenv("kmsEndpoint")));
        LOGGER.info("using kmsEndpoint {}.", (Object)kmsEndpoint);
        Config config = new Config();
        this.runtimeOptions = new RuntimeOptions();
        boolean ifAuth = false;
        com.aliyun.credentials.models.Config credentialConfig = new com.aliyun.credentials.models.Config();
        for (KmsCredentialsProvider each : this.credentialsProviders) {
            if (!each.matchProvider(properties)) continue;
            LOGGER.info("Match Kms credentials provider: {}", (Object)each.getClass().getName());
            credentialConfig = each.generateCredentialsConfig(properties);
            ifAuth = true;
            break;
        }
        if (!ifAuth) {
            String msg = "Ram Auth Information are not set up yet";
            LOGGER.error(msg);
            this.localInitException = new RuntimeException(msg);
            return null;
        }
        Client credentialClient = new Client(credentialConfig);
        config.setCredential(credentialClient);
        config.setRegionId(kmsRegionId);
        if (!StringUtils.isBlank((CharSequence)kmsEndpoint)) {
            config.setEndpoint(kmsEndpoint);
            this.keyId = properties.getProperty("keyId", System.getProperty("keyId", System.getenv("keyId")));
            if (StringUtils.isBlank((CharSequence)this.keyId)) {
                String msg = "keyId is not set up yet, unable to encrypt the configuration.";
                LOGGER.error(msg);
            } else {
                LOGGER.info("using keyId {}.", (Object)this.keyId);
            }
        } else {
            LOGGER.info("kmsEndpoint is not set up yet, KMS V1.0 mode");
            if (StringUtils.isBlank((CharSequence)kmsRegionId) && StringUtils.isBlank((CharSequence)regionId)) {
                String errorMsg = "KMS V1.0 mode, region is not set up yet";
                LOGGER.error(AliyunConst.formatHelpMessage(errorMsg));
                this.localInitException = new RuntimeException(errorMsg);
                return null;
            }
            this.keyId = "alias/acs/mse";
            return new com.aliyun.kms20160120.Client(config);
        }
        String kmsCaFileContent = properties.getProperty("kmsCaFileContent", System.getProperty("kmsCaFileContent", System.getenv("kmsCaFileContent")));
        if (StringUtils.isBlank((CharSequence)kmsCaFileContent) && !StringUtils.isBlank((CharSequence)(kmsCaFilePath = properties.getProperty("kmsCaFilePath", System.getProperty("kmsCaFilePath", System.getenv("kmsCaFilePath")))))) {
            try {
                kmsCaFileContent = this.readFileToString(kmsCaFilePath);
            }
            catch (Exception e) {
                LOGGER.error("read kms ca file failed.", (Throwable)e);
            }
        }
        if (!StringUtils.isBlank((CharSequence)kmsCaFileContent)) {
            LOGGER.info("using {}: {}.", (Object)"kmsCaFileContent", (Object)kmsCaFileContent);
            config.setCa(kmsCaFileContent);
        } else {
            this.runtimeOptions.ignoreSSL = true;
        }
        String openSSL = properties.getProperty("openSSL", System.getProperty("openSSL", System.getenv("openSSL")));
        if (!StringUtils.isBlank((CharSequence)openSSL)) {
            if (openSSL.equalsIgnoreCase("false")) {
                LOGGER.info("openSSL is set to false.");
                this.runtimeOptions.ignoreSSL = true;
            } else if (openSSL.equalsIgnoreCase("true")) {
                LOGGER.info("ignoreSSL is set to true.");
                this.runtimeOptions.ignoreSSL = false;
            }
        }
        return new com.aliyun.kms20160120.Client(config);
    }

    @Override
    public String encrypt(String plainText) throws Exception {
        AtomicReference resultContent = new AtomicReference();
        EncryptRequest encReq = new EncryptRequest();
        encReq.setKeyId(this.keyId);
        encReq.setPlaintext(plainText);
        this.locallyRunWithRetryTimesAndTimeout(() -> {
            try {
                resultContent.set(this.kmsClient.encryptWithOptions(encReq, this.runtimeOptions).getBody().getCiphertextBlob());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (StringUtils.isBlank((CharSequence)((CharSequence)resultContent.get()))) {
                return false;
            }
            return true;
        }, 3, 3000L);
        return (String)resultContent.get();
    }

    @Override
    public String decrypt(String encryptedContent) throws Exception {
        AtomicReference resultContent = new AtomicReference();
        DecryptRequest decReq = new DecryptRequest();
        decReq.setCiphertextBlob(encryptedContent);
        this.locallyRunWithRetryTimesAndTimeout(() -> {
            try {
                resultContent.set(this.kmsClient.decryptWithOptions(decReq, this.runtimeOptions).getBody().getPlaintext());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (StringUtils.isBlank((CharSequence)((CharSequence)resultContent.get()))) {
                return false;
            }
            return true;
        }, 3, 3000L);
        return (String)resultContent.get();
    }

    @Override
    public void checkIfKmsClientIsReady() throws Exception {
        if (this.kmsClient == null) {
            if (this.localInitException != null) {
                throw this.localInitException;
            }
            throw new RuntimeException("kms client isn't initialized. For more information, please check: https://help.aliyun.com/zh/mse/user-guide/create-and-use-encrypted-configurations?spm=a2c4g.11186623.0.0.55587becdOW3jf");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void protectKeyId() {
        if (!this.addedKeys.contains(this.keyId)) {
            Set<String> set = this.addedKeys;
            synchronized (set) {
                if (this.addedKeys.contains(this.keyId)) {
                    return;
                }
                this.addedKeys.add(this.keyId);
                this.asyncProcessor.addTack(new Runnable(){

                    @Override
                    public void run() {
                        block9: {
                            try {
                                if (RamKmsEncryptor.this.kmsClient == null) {
                                    LOGGER.error("kms client hasn't initiated.");
                                    return;
                                }
                                DescribeKeyRequest describeKeyRequest = new DescribeKeyRequest();
                                describeKeyRequest.setKeyId(RamKmsEncryptor.this.keyId);
                                try {
                                    DescribeKeyResponse describeKeyResponse = RamKmsEncryptor.this.kmsClient.describeKeyWithOptions(describeKeyRequest, RamKmsEncryptor.this.runtimeOptions);
                                    if (describeKeyResponse.getBody().getKeyMetadata() != null) {
                                        if (!"Enabled".equals(describeKeyResponse.getBody().getKeyMetadata().getKeyState())) {
                                            throw new RuntimeException("Key not available");
                                        }
                                        String arn = describeKeyResponse.getBody().getKeyMetadata().getArn();
                                        LOGGER.info("set deletion protection for keyId[{}], arn[{}]", (Object)RamKmsEncryptor.this.keyId, (Object)arn);
                                        SetDeletionProtectionRequest setDeletionProtectionRequest = new SetDeletionProtectionRequest();
                                        setDeletionProtectionRequest.setProtectedResourceArn(arn);
                                        setDeletionProtectionRequest.setEnableDeletionProtection(Boolean.valueOf(true));
                                        setDeletionProtectionRequest.setDeletionProtectionDescription("key is used by mse");
                                        try {
                                            RamKmsEncryptor.this.kmsClient.setDeletionProtectionWithOptions(setDeletionProtectionRequest, RamKmsEncryptor.this.runtimeOptions);
                                            break block9;
                                        }
                                        catch (ClientException e) {
                                            LOGGER.error("set deletion protect failed, keyId: {}.", (Object)RamKmsEncryptor.this.keyId);
                                            throw e;
                                        }
                                    }
                                    RamKmsEncryptor.this.addedKeys.remove(RamKmsEncryptor.this.keyId);
                                    LOGGER.warn("keyId meta is null, cannot set key protection");
                                }
                                catch (ClientException e) {
                                    LOGGER.error("describe key failed, keyId: {}.", (Object)RamKmsEncryptor.this.keyId);
                                    throw e;
                                }
                            }
                            catch (Exception e) {
                                RamKmsEncryptor.this.addedKeys.remove(RamKmsEncryptor.this.keyId);
                                LOGGER.error("execute async task failed", (Throwable)e);
                            }
                        }
                    }
                });
            }
        }
    }

    @Override
    public KmsEncryptor.DataKey generateDataKey(String keySpec) throws Exception {
        GenerateDataKeyRequest generateDataKeyRequest = new GenerateDataKeyRequest();
        generateDataKeyRequest.setKeyId(this.keyId);
        generateDataKeyRequest.setKeySpec(keySpec);
        AtomicReference resultContent = new AtomicReference();
        this.locallyRunWithRetryTimesAndTimeout(() -> {
            try {
                resultContent.set(this.kmsClient.generateDataKeyWithOptions(generateDataKeyRequest, this.runtimeOptions).getBody());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (resultContent.get() == null) {
                return false;
            }
            return true;
        }, 3, 3000L);
        KmsEncryptor.DataKey dataKey = new KmsEncryptor.DataKey();
        dataKey.setEncryptedDataKey(((GenerateDataKeyResponseBody)resultContent.get()).getCiphertextBlob());
        dataKey.setPlainDataKey(((GenerateDataKeyResponseBody)resultContent.get()).getPlaintext());
        return dataKey;
    }

    @Override
    public void checkKeyId() throws Exception {
        this.throwExceptionIfStringBlankWithErrorKey(this.keyId, "", "keyId is not set.", "keyId");
    }

    @Override
    public void close() throws IOException {
        this.asyncProcessor.shutdown();
    }
}

