/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.org.postgresql.jdbc;

import com.alibaba.hologres.org.postgresql.jdbc.ArrayEncoding;
import com.alibaba.hologres.org.postgresql.jdbc.PgArray;
import com.alibaba.hologres.org.postgresql.util.PSQLException;
import java.util.List;

public class ArrayUtil {
    public static String arrayToString(Object elements) throws PSQLException {
        ArrayEncoding.ArrayEncoder<Object> arraySupport = ArrayEncoding.getArrayEncoder(elements);
        String arrayString = arraySupport.toArrayString(',', elements);
        return arrayString;
    }

    public static void reverse(byte[] array) {
        if (array != null) {
            int i = 0;
            for (int j = array.length - 1; j > i; --j, ++i) {
                byte tmp = array[j];
                array[j] = array[i];
                array[i] = tmp;
            }
        }
    }

    public static long getArrayLength(String[] array) {
        long len = 0L;
        if (array != null) {
            for (String str : array) {
                if (str == null) continue;
                len += (long)str.length();
            }
        }
        return len;
    }

    public static long getArrayLength(Object[] array, String typeName) {
        long len = 0L;
        if (array != null) {
            switch (typeName) {
                case "_int4": 
                case "_float4": {
                    len = (long)array.length * 4L;
                    break;
                }
                case "_int8": 
                case "_float8": {
                    len = (long)array.length * 8L;
                    break;
                }
                case "_bool": {
                    len = array.length;
                    break;
                }
                case "_text": {
                    for (Object str : array) {
                        if (str == null) continue;
                        len += (long)str.toString().length();
                    }
                    break;
                }
                default: {
                    len = 32L;
                }
            }
        }
        return len;
    }

    public static long getArrayLength(List<?> array, String typeName) {
        long len = 0L;
        if (array != null) {
            switch (typeName) {
                case "_int4": 
                case "_float4": {
                    len = (long)array.size() * 4L;
                    break;
                }
                case "_int8": 
                case "_float8": {
                    len = (long)array.size() * 8L;
                    break;
                }
                case "_bool": {
                    len = array.size();
                    break;
                }
                case "_text": {
                    for (Object str : array) {
                        if (str == null) continue;
                        len += (long)str.toString().length();
                    }
                    break;
                }
                default: {
                    len = 32L;
                }
            }
        }
        return len;
    }

    public static long getArrayLength(PgArray array) {
        long len = 0L;
        len = array != null && array.toString() != null ? (long)array.toString().length() : 1024L;
        return len;
    }
}

