/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.model;

import com.alibaba.hologres.client.exception.HoloClientException;
import com.alibaba.hologres.client.impl.copy.CopyContext;
import com.alibaba.hologres.org.postgresql.jdbc.TimestampUtils;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public class ExportContext {
    private CompletableFuture<Long> totalRowCount;
    private CompletableFuture<Long>[] rowCounts;
    private InputStream[] istreams;
    private CopyContext[] copyContexts;

    public ExportContext(CompletableFuture<Long>[] rowCounts, CopyContext[] copyContexts, InputStream[] istreams) {
        this.rowCounts = rowCounts;
        this.istreams = istreams;
        this.copyContexts = copyContexts;
        this.totalRowCount = CompletableFuture.allOf(rowCounts).thenApply(ignore -> Stream.of(rowCounts).mapToLong(CompletableFuture::join).sum());
    }

    public CompletableFuture<Long> getRowCount() {
        return this.totalRowCount;
    }

    public InputStream getInputStream(int n) {
        return this.istreams[n];
    }

    public int getThreadSize() {
        return this.istreams.length;
    }

    public void cancel() throws HoloClientException {
        try {
            for (CopyContext copyContext : this.copyContexts) {
                copyContext.cancel();
            }
        }
        catch (SQLException e) {
            throw HoloClientException.fromSqlException(e);
        }
    }

    public TimestampUtils getTimestampUtils() {
        return this.copyContexts[0].getConn().getTimestampUtils();
    }
}

